/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session;

import org.jsmpp.extra.SessionState;
import org.jsmpp.session.AbstractSessionContext;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.session.SessionStateListener;
import org.jsmpp.session.state.SMPPSessionState;

public class SMPPSessionContext
extends AbstractSessionContext {
    private final SMPPSession smppSession;
    private SMPPSessionState stateProcessor = SMPPSessionState.CLOSED;

    public SMPPSessionContext(SMPPSession smppSession, SessionStateListener sessionStateListener) {
        super(sessionStateListener);
        this.smppSession = smppSession;
    }

    public synchronized SMPPSessionState getStateProcessor() {
        return this.stateProcessor;
    }

    @Override
    public synchronized SessionState getSessionState() {
        return this.stateProcessor.getSessionState();
    }

    @Override
    protected void changeState(SessionState newState) {
        if (!this.stateProcessor.getSessionState().equals((Object)newState)) {
            SessionState oldState = this.stateProcessor.getSessionState();
            if (newState == SessionState.OPEN) {
                this.stateProcessor = SMPPSessionState.OPEN;
            } else if (newState == SessionState.BOUND_RX) {
                this.stateProcessor = SMPPSessionState.BOUND_RX;
            } else if (newState == SessionState.BOUND_TX) {
                this.stateProcessor = SMPPSessionState.BOUND_TX;
            } else if (newState == SessionState.BOUND_TRX) {
                this.stateProcessor = SMPPSessionState.BOUND_TRX;
            } else if (newState == SessionState.UNBOUND) {
                this.stateProcessor = SMPPSessionState.UNBOUND;
            } else if (newState == SessionState.CLOSED) {
                this.stateProcessor = SMPPSessionState.CLOSED;
            }
            this.fireStateChanged(newState, oldState, this.smppSession);
        }
    }
}

