/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.nodes.stats.ProcessCpuStats;
import org.opensearch.client.opensearch.nodes.stats.ProcessMemoryStats;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class Process
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, Process> {
    @Nullable
    private final ProcessCpuStats cpu;
    @Nullable
    private final Long maxFileDescriptors;
    @Nullable
    private final ProcessMemoryStats mem;
    @Nullable
    private final Long openFileDescriptors;
    @Nullable
    private final Long timestamp;
    public static final JsonpDeserializer<Process> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Process::setupProcessDeserializer);

    private Process(Builder builder) {
        this.cpu = builder.cpu;
        this.maxFileDescriptors = builder.maxFileDescriptors;
        this.mem = builder.mem;
        this.openFileDescriptors = builder.openFileDescriptors;
        this.timestamp = builder.timestamp;
    }

    public static Process of(Function<Builder, ObjectBuilder<Process>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final ProcessCpuStats cpu() {
        return this.cpu;
    }

    @Nullable
    public final Long maxFileDescriptors() {
        return this.maxFileDescriptors;
    }

    @Nullable
    public final ProcessMemoryStats mem() {
        return this.mem;
    }

    @Nullable
    public final Long openFileDescriptors() {
        return this.openFileDescriptors;
    }

    @Nullable
    public final Long timestamp() {
        return this.timestamp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.cpu != null) {
            generator.writeKey("cpu");
            this.cpu.serialize(generator, mapper);
        }
        if (this.maxFileDescriptors != null) {
            generator.writeKey("max_file_descriptors");
            generator.write(this.maxFileDescriptors.longValue());
        }
        if (this.mem != null) {
            generator.writeKey("mem");
            this.mem.serialize(generator, mapper);
        }
        if (this.openFileDescriptors != null) {
            generator.writeKey("open_file_descriptors");
            generator.write(this.openFileDescriptors.longValue());
        }
        if (this.timestamp != null) {
            generator.writeKey("timestamp");
            generator.write(this.timestamp.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupProcessDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::cpu, ProcessCpuStats._DESERIALIZER, "cpu");
        op.add(Builder::maxFileDescriptors, JsonpDeserializer.longDeserializer(), "max_file_descriptors");
        op.add(Builder::mem, ProcessMemoryStats._DESERIALIZER, "mem");
        op.add(Builder::openFileDescriptors, JsonpDeserializer.longDeserializer(), "open_file_descriptors");
        op.add(Builder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.cpu);
        result = 31 * result + Objects.hashCode(this.maxFileDescriptors);
        result = 31 * result + Objects.hashCode(this.mem);
        result = 31 * result + Objects.hashCode(this.openFileDescriptors);
        result = 31 * result + Objects.hashCode(this.timestamp);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Process other = (Process)o;
        return Objects.equals(this.cpu, other.cpu) && Objects.equals(this.maxFileDescriptors, other.maxFileDescriptors) && Objects.equals(this.mem, other.mem) && Objects.equals(this.openFileDescriptors, other.openFileDescriptors) && Objects.equals(this.timestamp, other.timestamp);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, Process> {
        @Nullable
        private ProcessCpuStats cpu;
        @Nullable
        private Long maxFileDescriptors;
        @Nullable
        private ProcessMemoryStats mem;
        @Nullable
        private Long openFileDescriptors;
        @Nullable
        private Long timestamp;

        public Builder() {
        }

        private Builder(Process o) {
            this.cpu = o.cpu;
            this.maxFileDescriptors = o.maxFileDescriptors;
            this.mem = o.mem;
            this.openFileDescriptors = o.openFileDescriptors;
            this.timestamp = o.timestamp;
        }

        private Builder(Builder o) {
            this.cpu = o.cpu;
            this.maxFileDescriptors = o.maxFileDescriptors;
            this.mem = o.mem;
            this.openFileDescriptors = o.openFileDescriptors;
            this.timestamp = o.timestamp;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder cpu(@Nullable ProcessCpuStats value) {
            this.cpu = value;
            return this;
        }

        @Nonnull
        public final Builder cpu(Function<ProcessCpuStats.Builder, ObjectBuilder<ProcessCpuStats>> fn) {
            return this.cpu(fn.apply(new ProcessCpuStats.Builder()).build());
        }

        @Nonnull
        public final Builder maxFileDescriptors(@Nullable Long value) {
            this.maxFileDescriptors = value;
            return this;
        }

        @Nonnull
        public final Builder mem(@Nullable ProcessMemoryStats value) {
            this.mem = value;
            return this;
        }

        @Nonnull
        public final Builder mem(Function<ProcessMemoryStats.Builder, ObjectBuilder<ProcessMemoryStats>> fn) {
            return this.mem(fn.apply(new ProcessMemoryStats.Builder()).build());
        }

        @Nonnull
        public final Builder openFileDescriptors(@Nullable Long value) {
            this.openFileDescriptors = value;
            return this;
        }

        @Nonnull
        public final Builder timestamp(@Nullable Long value) {
            this.timestamp = value;
            return this;
        }

        @Override
        @Nonnull
        public Process build() {
            this._checkSingleUse();
            return new Process(this);
        }
    }
}

