/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.securityconf.impl.v7;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.opensearch.OpenSearchCorruptionException;
import org.opensearch.security.DefaultObjectMapper;
import org.opensearch.security.securityconf.Hideable;
import org.opensearch.security.securityconf.StaticDefinable;

public class RoleV7
implements Hideable,
StaticDefinable {
    private boolean reserved;
    private boolean hidden;
    @JsonProperty(value="static")
    private boolean _static;
    private String description;
    private List<String> cluster_permissions = Collections.emptyList();
    private List<Index> index_permissions = Collections.emptyList();
    private List<Tenant> tenant_permissions = Collections.emptyList();

    public static RoleV7 fromYamlString(String yamlString) throws IOException {
        try (StringReader yamlReader = new StringReader(yamlString);){
            RoleV7 roleV7 = RoleV7.fromYaml(yamlReader);
            return roleV7;
        }
    }

    public static RoleV7 fromYamlStringUnchecked(String yamlString) {
        RoleV7 roleV7;
        StringReader yamlReader = new StringReader(yamlString);
        try {
            roleV7 = RoleV7.fromYaml(yamlReader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)yamlReader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ((Reader)yamlReader).close();
        return roleV7;
    }

    public static RoleV7 fromYaml(URL yamlFile) throws IOException {
        try (InputStream in = yamlFile.openStream();){
            RoleV7 roleV7;
            try (InputStreamReader yamlReader = new InputStreamReader(in, StandardCharsets.UTF_8);){
                roleV7 = RoleV7.fromYaml(yamlReader);
            }
            return roleV7;
        }
    }

    public static RoleV7 fromYaml(Reader yamlReader) throws IOException {
        return (RoleV7)DefaultObjectMapper.YAML_MAPPER.readValue(yamlReader, RoleV7.class);
    }

    public static RoleV7 fromPluginPermissionsFile(URL pluginPermissionsFile) throws IOException {
        RoleV7 role = RoleV7.fromYaml(pluginPermissionsFile);
        if (role.tenant_permissions != null && !role.tenant_permissions.isEmpty()) {
            throw new OpenSearchCorruptionException("Unsupported key tenant_permissions. Only 'cluster_permissions' and 'index_permissions' are allowed.");
        }
        return role;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getCluster_permissions() {
        return this.cluster_permissions;
    }

    public void setCluster_permissions(List<String> cluster_permissions) {
        this.cluster_permissions = cluster_permissions;
    }

    public List<Index> getIndex_permissions() {
        return this.index_permissions;
    }

    public void setIndex_permissions(List<Index> index_permissions) {
        this.index_permissions = index_permissions;
    }

    public List<Tenant> getTenant_permissions() {
        return this.tenant_permissions;
    }

    public void setTenant_permissions(List<Tenant> tenant_permissions) {
        this.tenant_permissions = tenant_permissions;
    }

    @Override
    public boolean isReserved() {
        return this.reserved;
    }

    public void setReserved(boolean reserved) {
        this.reserved = reserved;
    }

    @Override
    @JsonProperty(value="static")
    public boolean isStatic() {
        return this._static;
    }

    @JsonProperty(value="static")
    public void setStatic(boolean _static) {
        this._static = _static;
    }

    public String toString() {
        return "RoleV7 [reserved=" + this.reserved + ", hidden=" + this.hidden + ", _static=" + this._static + ", description=" + this.description + ", cluster_permissions=" + String.valueOf(this.cluster_permissions) + ", index_permissions=" + String.valueOf(this.index_permissions) + ", tenant_permissions=" + String.valueOf(this.tenant_permissions) + "]";
    }

    public static class Tenant {
        private List<String> tenant_patterns = Collections.emptyList();
        private List<String> allowed_actions = Collections.emptyList();

        public List<String> getTenant_patterns() {
            return this.tenant_patterns;
        }

        public void setTenant_patterns(List<String> tenant_patterns) {
            this.tenant_patterns = tenant_patterns;
        }

        public List<String> getAllowed_actions() {
            return this.allowed_actions;
        }

        public void setAllowed_actions(List<String> allowed_actions) {
            this.allowed_actions = allowed_actions;
        }

        public String toString() {
            return "Tenant [tenant_patterns=" + String.valueOf(this.tenant_patterns) + ", allowed_actions=" + String.valueOf(this.allowed_actions) + "]";
        }
    }

    public static class Index {
        private List<String> index_patterns = Collections.emptyList();
        private String dls;
        private List<String> fls = Collections.emptyList();
        private List<String> masked_fields = Collections.emptyList();
        private List<String> allowed_actions = Collections.emptyList();

        public List<String> getIndex_patterns() {
            return this.index_patterns;
        }

        public void setIndex_patterns(List<String> index_patterns) {
            this.index_patterns = index_patterns;
        }

        public String getDls() {
            return this.dls;
        }

        public void setDls(String dls) {
            this.dls = dls;
        }

        public List<String> getFls() {
            return this.fls;
        }

        public void setFls(List<String> fls) {
            this.fls = fls;
        }

        public List<String> getMasked_fields() {
            return this.masked_fields;
        }

        public void setMasked_fields(List<String> masked_fields) {
            this.masked_fields = masked_fields;
        }

        public List<String> getAllowed_actions() {
            return this.allowed_actions;
        }

        public void setAllowed_actions(List<String> allowed_actions) {
            this.allowed_actions = allowed_actions;
        }

        public String toString() {
            return "Index [index_patterns=" + String.valueOf(this.index_patterns) + ", dls=" + this.dls + ", fls=" + String.valueOf(this.fls) + ", masked_fields=" + String.valueOf(this.masked_fields) + ", allowed_actions=" + String.valueOf(this.allowed_actions) + "]";
        }
    }
}

