import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { GetDistributionConfigResultFilterSensitiveLog, } from "../models/models_1";
import { de_GetDistributionConfigCommand, se_GetDistributionConfigCommand } from "../protocols/Aws_restXml";
export { $Command };
export class GetDistributionConfigCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("Cloudfront2020_05_31", "GetDistributionConfig", {})
    .n("CloudFrontClient", "GetDistributionConfigCommand")
    .f(void 0, GetDistributionConfigResultFilterSensitiveLog)
    .ser(se_GetDistributionConfigCommand)
    .de(de_GetDistributionConfigCommand)
    .build() {
}
