/**
 * ./src/components/install.tsx
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import fs from 'fs';
import { Box, Newline, Text } from 'ink';
import Spinner from 'ink-spinner';
import yaml from 'js-yaml';
import React from 'react';
import Steps from './steps.js';
import Title from './title.js';
export default function Install({ message = "Install", percent = 0, spinner = false }) {
    let productName = 'unknown';
    let version = 'x.x.x';
    let configRoot = '/etc/penguins-eggs.d/krill/';
    if (fs.existsSync('/etc/calamares/settings.conf')) {
        configRoot = '/etc/calamares/';
    }
    const settings = yaml.load(fs.readFileSync(configRoot + 'settings.conf', 'utf8'));
    const { branding } = settings;
    const calamares = yaml.load(fs.readFileSync(configRoot + 'branding/' + branding + '/branding.desc', 'utf8'));
    productName = calamares.strings.productName;
    version = calamares.strings.version;
    const barLen = 53;
    const progress = Math.round(barLen * percent / 100);
    const todo = barLen - progress;
    const clean = "·".repeat(todo);
    const progressBar = "[" + "█".repeat(progress) + clean + "] " + percent + "%";
    /**
     * totale width=75
     * step width=15
     * finestra with=59
     *                 <Text><Spinner type="simpleDotsScrolling" /></Text>
     */
    return (React.createElement(React.Fragment, null,
        React.createElement(Title, null),
        React.createElement(Box, { borderStyle: "round", flexDirection: "column", height: 11, width: 75 },
            React.createElement(Box, { flexDirection: "column" },
                React.createElement(Box, { flexDirection: "row" },
                    React.createElement(Steps, { step: 8 }),
                    React.createElement(Box, { flexDirection: "column" },
                        React.createElement(Box, { flexDirection: "row" },
                            React.createElement(Text, null, "Installing: "),
                            React.createElement(Text, { color: "cyan" }, productName)),
                        React.createElement(Newline, null),
                        React.createElement(Box, { flexDirection: "row" },
                            React.createElement(Text, null, "Step: "),
                            React.createElement(Text, { color: "cyan" },
                                message,
                                " "),
                            spinner && React.createElement(Text, null,
                                React.createElement(Spinner, { type: "simpleDotsScrolling" }))),
                        React.createElement(Newline, null),
                        React.createElement(Box, null,
                            React.createElement(Text, null, progressBar)))))),
        React.createElement(Text, null)));
}
