# MakeConstrained\[T: [Any](builtin-Any.md) val, F: [Validator](constrained_types-Validator.md)\[T\] val\]
<span class="source-link">[[Source]](src/constrained_types/constrained.md#L-0-61)</span>

Builder of `Constrained` instances.


```pony
primitive val MakeConstrained[T: Any val, F: Validator[T] val]
```

## Constructors

### create
<span class="source-link">[[Source]](src/constrained_types/constrained.md#L-0-61)</span>


```pony
new val create()
: MakeConstrained[T, F] val^
```

#### Returns

* [MakeConstrained](constrained_types-MakeConstrained.md)\[T, F\] val^

---

## Public Functions

### apply
<span class="source-link">[[Source]](src/constrained_types/constrained.md#L-0-65)</span>


```pony
fun box apply(
  value: T)
: (Constrained[T, F] val | ValidationFailure val)
```
#### Parameters

*   value: T

#### Returns

* ([Constrained](constrained_types-Constrained.md)\[T, F\] val | [ValidationFailure](constrained_types-ValidationFailure.md) val)

---

### eq
<span class="source-link">[[Source]](src/constrained_types/constrained.md#L-0-65)</span>


```pony
fun box eq(
  that: MakeConstrained[T, F] val)
: Bool val
```
#### Parameters

*   that: [MakeConstrained](constrained_types-MakeConstrained.md)\[T, F\] val

#### Returns

* [Bool](builtin-Bool.md) val

---

### ne
<span class="source-link">[[Source]](src/constrained_types/constrained.md#L-0-65)</span>


```pony
fun box ne(
  that: MakeConstrained[T, F] val)
: Bool val
```
#### Parameters

*   that: [MakeConstrained](constrained_types-MakeConstrained.md)\[T, F\] val

#### Returns

* [Bool](builtin-Bool.md) val

---

