/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.FileMapType;
import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TextualContentCommand;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.datatool.AddDelimiterOption;
import com.dickimawbooks.texparserlib.latex.datatool.CsvReadHandler;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolEntry;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolEntryRow;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolHeader;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolHeaderRow;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolRows;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolSty;
import com.dickimawbooks.texparserlib.latex.datatool.DatumElement;
import com.dickimawbooks.texparserlib.latex.datatool.EscapeCharsOption;
import com.dickimawbooks.texparserlib.latex.datatool.FileFormatType;
import com.dickimawbooks.texparserlib.latex.datatool.IOExpandOption;
import com.dickimawbooks.texparserlib.latex.datatool.IOSettings;
import com.dickimawbooks.texparserlib.latex.datatool.PostReadHook;
import com.dickimawbooks.texparserlib.latex.inputenc.InputEncSty;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataBase {
    private DataToolHeaderRow headerRow;
    private DataToolRows dataRows;
    private String name;
    public static Pattern FILE_IDENTIFIER = Pattern.compile("% (DBTEX|DTLTEX) ([0-9\\.]+) ([a-zA-Z0-9\\-]+)");
    public static String FILE_INFO = "datatool.file_info";
    public static String ERROR_FILE_INFO_FAILED = "datatool.file_info_failed";
    public static String ERROR_FILE_FORMAT_VERSION = "datatool.unknown_file_format_version";

    public DataBase(String string) {
        this(string, null, null);
    }

    public DataBase(String string, DataToolHeaderRow dataToolHeaderRow, DataToolRows dataToolRows) {
        this.name = string;
        this.update(dataToolHeaderRow, dataToolRows);
    }

    public void update(DataToolHeaderRow dataToolHeaderRow, DataToolRows dataToolRows) {
        this.headerRow = dataToolHeaderRow;
        this.dataRows = dataToolRows;
    }

    public int getColumnCount() {
        return this.headerRow == null ? 0 : this.headerRow.size();
    }

    public int getRowCount() {
        return this.dataRows == null ? 0 : this.dataRows.size();
    }

    public DataToolHeaderRow getHeaders() {
        return this.headerRow;
    }

    public DataToolHeader getHeader(String string) {
        return this.headerRow.getHeader(string);
    }

    public DataToolHeader getHeader(int n) {
        return this.headerRow.getHeader(n);
    }

    public DataToolRows getData() {
        return this.dataRows;
    }

    public String getName() {
        return this.name;
    }

    public static void read(DataToolSty dataToolSty, TeXPath teXPath, IOSettings iOSettings, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXParserListener teXParserListener = teXParser.getListener();
        Charset charset = teXPath.getEncoding();
        if (charset == null) {
            charset = teXParserListener.getCharSet();
        }
        DataBase.read(dataToolSty, teXPath, iOSettings, charset, teXParser, teXObjectList);
    }

    public static void read(DataToolSty dataToolSty, TeXPath teXPath, IOSettings iOSettings, Charset charset, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXParserListener teXParserListener = teXParser.getListener();
        TeXApp teXApp = teXParserListener.getTeXApp();
        if (charset != null) {
            teXPath.setEncoding(charset);
        }
        FileFormatType fileFormatType = iOSettings.getFormat();
        String string = iOSettings.getFileVersion();
        if (teXPath.exists()) {
            if (fileFormatType == FileFormatType.DTLTEX || fileFormatType == FileFormatType.DBTEX) {
                BufferedReader bufferedReader;
                block21: {
                    teXObjectList.push(new PostReadHook(dataToolSty, teXPath));
                    teXParserListener.addFileReference(teXPath);
                    String string2 = null;
                    bufferedReader = null;
                    try {
                        Matcher matcher;
                        bufferedReader = teXApp.createBufferedReader(teXPath.getPath(), charset);
                        String string3 = bufferedReader.readLine();
                        if (string3 == null || !(matcher = FILE_IDENTIFIER.matcher(string3)).matches()) break block21;
                        String string4 = matcher.group(1).toLowerCase();
                        fileFormatType = string4.equals("dbtex") ? FileFormatType.DBTEX : FileFormatType.DTLTEX;
                        String string5 = matcher.group(2);
                        if (string5.equals("2.0") || string5.equals("3.0")) {
                            string = string5;
                        } else {
                            teXApp.warning(teXParser, teXApp.getMessage(ERROR_FILE_FORMAT_VERSION, string4, string5));
                        }
                        string2 = matcher.group(3);
                        try {
                            charset = Charset.forName(string2);
                        }
                        catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
                            string2 = InputEncSty.getCharSetName(matcher.group(3));
                            charset = Charset.forName(string2);
                        }
                        teXPath.setEncoding(charset);
                        teXApp.message(teXApp.getMessage(FILE_INFO, string4, string5, charset.name()));
                    }
                    catch (MalformedInputException malformedInputException) {
                        teXApp.warning(teXParser, teXApp.getMessage(ERROR_FILE_INFO_FAILED, teXPath, teXApp.getDefaultCharset()));
                        teXParser.logMessage(malformedInputException);
                    }
                    catch (UnsupportedCharsetException unsupportedCharsetException) {
                        teXApp.warning(teXParser, teXApp.getMessage("inputenc.unknown.encoding", string2));
                        teXParser.logMessage(unsupportedCharsetException);
                    }
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                teXParser.putControlSequence(true, new TextualContentCommand("l__texparser_current_file_type_tl", fileFormatType.toString()));
                teXParser.putControlSequence(true, new TextualContentCommand("l__texparser_current_file_version_tl", string));
                teXParserListener.input(teXPath, teXObjectList);
            } else {
                String string6 = iOSettings.getDefaultName();
                if (string6 == null) {
                    string6 = TeXParserUtils.getControlSequenceValue("l__datatool_default_dbname_tl", "untitled", teXParser, teXObjectList);
                }
                boolean bl = false;
                DataBase dataBase = null;
                if (dataToolSty.dbExists(string6)) {
                    dataBase = dataToolSty.getDataBase(string6);
                }
                if (dataBase == null) {
                    dataBase = dataToolSty.createDataBase(string6, true);
                } else if (iOSettings.isAppendAllowed()) {
                    bl = true;
                } else {
                    throw new LaTeXSyntaxException(teXParser, "datatool.db_exists", string6);
                }
                teXParser.putControlSequence(true, new TextualContentCommand("dtllastloadeddb", string6));
                int n = iOSettings.getSeparator();
                int n2 = iOSettings.getDelimiter();
                int n3 = teXParser.getCatCode(n);
                if (n3 != 12) {
                    teXParser.setCatCode(true, n, 12);
                }
                if ((n3 = teXParser.getCatCode(n2)) != 12) {
                    teXParser.setCatCode(true, n2, 12);
                }
                FileMapType fileMapType = iOSettings.isCsvLiteral() ? FileMapType.VERBATIM_EXCEPT_ESC_SYM : FileMapType.TEX;
                teXParser.fileMap(teXPath, fileMapType, new CsvReadHandler(dataBase, bl, iOSettings));
            }
        } else {
            throw new TeXSyntaxException(teXParser, "tex.error.file.not.found", teXPath);
        }
    }

    public static void write(DataToolSty dataToolSty, String string, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        IOSettings iOSettings = IOSettings.fetchWriteSettings(dataToolSty, teXParser, teXObjectList);
        String string2 = iOSettings.getDefaultExtension();
        TeXPath teXPath = TeXPath.newOutputPath(teXParser, string, string2);
        String string3 = iOSettings.getDefaultName();
        DataBase dataBase = dataToolSty.getDataBase(string3);
        if (dataBase == null) {
            throw new LaTeXSyntaxException(teXParser, "datatool.db_doesnt_exist", string3);
        }
        dataBase.write(teXParser, teXObjectList, teXPath, iOSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(TeXParser teXParser, TeXObjectList teXObjectList, TeXPath teXPath, IOSettings iOSettings) throws IOException {
        TeXApp teXApp = teXParser.getListener().getTeXApp();
        if (!teXApp.isWriteAccessAllowed(teXPath)) {
            throw new TeXSyntaxException(teXParser, "message.no.write", teXPath);
        }
        if (teXPath.exists()) {
            switch (iOSettings.getOverwriteOption()) {
                case ERROR: {
                    throw new TeXSyntaxException(teXParser, "tex.error.file.overwrite_forbidden", teXPath);
                }
                case WARN: {
                    teXApp.warning(teXParser, teXApp.getMessage("warning.overwriting", teXPath));
                }
            }
        }
        Charset charset = teXApp.getDefaultCharset();
        FileFormatType fileFormatType = iOSettings.getFormat();
        String string = iOSettings.getFileVersion();
        boolean bl = iOSettings.isHeaderIncluded();
        IOExpandOption iOExpandOption = iOSettings.getExpandOption();
        try (PrintWriter printWriter = null;){
            printWriter = new PrintWriter(teXApp.createBufferedWriter(teXPath.getPath(), charset));
            teXApp.message(teXApp.getMessage("message.writing", teXPath));
            if (fileFormatType == FileFormatType.DBTEX || fileFormatType == FileFormatType.DTLTEX) {
                printWriter.print("% ");
                printWriter.print(fileFormatType.toString().toUpperCase());
                printWriter.print(" ");
                printWriter.print(string);
                printWriter.print(" ");
                printWriter.println(charset.name());
                printWriter.print("% ");
                printWriter.println(teXParser.getListener().getTeXApp().getMessage("datatool.write.comment", teXApp.getApplicationName(), teXApp.getApplicationVersion(), new Date()));
                if (fileFormatType == FileFormatType.DBTEX) {
                    if (string.equals("3.0")) {
                        Object object;
                        printWriter.print("\\DTLdbProvideData{");
                        printWriter.print(this.name);
                        printWriter.println("}%");
                        printWriter.println("\\DTLreconstructdatabase");
                        printWriter.print("{");
                        printWriter.print(this.getRowCount());
                        printWriter.print("}");
                        printWriter.print("{");
                        printWriter.print(this.getColumnCount());
                        printWriter.println("}");
                        printWriter.println("{% Header");
                        for (TeXObject teXObject : this.headerRow) {
                            printWriter.print("\\dtldbheaderreconstruct{");
                            printWriter.print(((DataToolHeader)teXObject).getColumnIndex());
                            printWriter.print("}{");
                            printWriter.print(((DataToolHeader)teXObject).getColumnLabel());
                            printWriter.print("}{");
                            printWriter.print(((DataToolHeader)teXObject).getType());
                            printWriter.print("}{");
                            object = ((DataToolHeader)teXObject).getTitle();
                            if (object == null) {
                                printWriter.print(((DataToolHeader)teXObject).getColumnLabel());
                            } else {
                                printWriter.print(object.toString(teXParser));
                            }
                            printWriter.println("}%");
                        }
                        printWriter.println("}% End of Header");
                        printWriter.println("{% Content");
                        for (TeXObject teXObject : this.dataRows) {
                            printWriter.print("% Row ");
                            printWriter.println(((DataToolEntryRow)teXObject).getRowIndex());
                            printWriter.print("\\dtldbrowreconstruct{");
                            printWriter.print(((DataToolEntryRow)teXObject).getRowIndex());
                            printWriter.println("}%");
                            printWriter.print("{% Row ");
                            printWriter.print(((DataToolEntryRow)teXObject).getRowIndex());
                            printWriter.println(" Content");
                            object = ((Vector)((Object)teXObject)).iterator();
                            while (object.hasNext()) {
                                DataToolEntry dataToolEntry = (DataToolEntry)object.next();
                                printWriter.print("  \\dtldbcolreconstruct{");
                                printWriter.print(dataToolEntry.getColumnIndex());
                                printWriter.print("}% Column ");
                                printWriter.println(dataToolEntry.getColumnIndex());
                                printWriter.print("  {% Column ");
                                printWriter.print(dataToolEntry.getColumnIndex());
                                printWriter.println("  Content");
                                TeXObject teXObject2 = dataToolEntry.getContents();
                                if (teXParser.isStack(teXObject2) && ((TeXObjectList)teXObject2).size() == 1 && ((TeXObjectList)teXObject2).firstElement() instanceof DatumElement) {
                                    teXObject2 = (TeXObject)((TeXObjectList)teXObject2).firstElement();
                                }
                                printWriter.print("   ");
                                if (teXObject2 instanceof DatumElement) {
                                    ((DatumElement)teXObject2).write(teXParser, printWriter, fileFormatType, string);
                                } else {
                                    printWriter.print("\\dtldbvaluereconstruct{");
                                    printWriter.print(teXObject2.toString(teXParser));
                                    printWriter.print("}");
                                }
                                printWriter.println("%");
                                printWriter.print("  }% End of Column ");
                                printWriter.print(dataToolEntry.getColumnIndex());
                                printWriter.println("  Content");
                            }
                            printWriter.println("}%");
                        }
                        printWriter.println("}% End of Content");
                        printWriter.println("{% Key to index");
                        for (TeXObject teXObject : this.headerRow) {
                            printWriter.print("\\dtldbreconstructkeyindex{");
                            printWriter.print(((DataToolHeader)teXObject).getColumnLabel());
                            printWriter.print("}{");
                            printWriter.print(((DataToolHeader)teXObject).getColumnIndex());
                            printWriter.println("}%");
                        }
                        printWriter.println("}% End of key to index");
                    } else {
                        Object object;
                        printWriter.print("\\DTLifdbexists{");
                        printWriter.print(this.name);
                        printWriter.println("}%");
                        printWriter.print("{\\PackageError{datatool}{Database `");
                        printWriter.print(this.name);
                        printWriter.println("' already exists}{}%");
                        printWriter.println("\\aftergroup\\endinput}{}%");
                        printWriter.println("\\bgroup\\makeatletter");
                        printWriter.print("\\dtl@message{Reconstructing database `");
                        printWriter.print(this.name);
                        printWriter.println("'}%");
                        printWriter.println("\\expandafter\\global\\expandafter");
                        printWriter.print("\\newtoks\\csname dtlkeys@");
                        printWriter.print(this.name);
                        printWriter.println("\\endcsname");
                        printWriter.println("\\expandafter\\global");
                        printWriter.print("\\csname dtlkeys@");
                        printWriter.print(this.name);
                        printWriter.println("\\endcsname={%");
                        for (TeXObject teXObject : this.headerRow) {
                            printWriter.print("% Header block for column ");
                            printWriter.println(((DataToolHeader)teXObject).getColumnIndex());
                            printWriter.println("\\db@plist@elt@w");
                            printWriter.print("\\db@col@id@w ");
                            printWriter.print(((DataToolHeader)teXObject).getColumnIndex());
                            printWriter.println("%");
                            printWriter.println("\\db@col@id@end@");
                            printWriter.print("\\db@key@id@w  ");
                            printWriter.print(((DataToolHeader)teXObject).getColumnLabel());
                            printWriter.println("%");
                            printWriter.println("\\db@key@id@end@");
                            printWriter.print("\\db@type@id@w  ");
                            printWriter.print(((DataToolHeader)teXObject).getType());
                            printWriter.println("%");
                            printWriter.println("\\db@type@id@end@");
                            printWriter.print("\\db@header@id@w  ");
                            object = ((DataToolHeader)teXObject).getTitle();
                            if (object == null) {
                                printWriter.print(((DataToolHeader)teXObject).getColumnLabel());
                            } else {
                                printWriter.print(object.toString(teXParser));
                            }
                            printWriter.println("%");
                            printWriter.println("\\db@header@id@end@");
                            printWriter.print("\\db@col@id@w ");
                            printWriter.print(((DataToolHeader)teXObject).getColumnIndex());
                            printWriter.println("%");
                            printWriter.println("\\db@col@id@end@");
                            printWriter.println("\\db@plist@elt@end@");
                        }
                        printWriter.println("}%");
                        printWriter.println("\\expandafter\\global\\expandafter");
                        printWriter.print("\\newtoks\\csname dtldb@");
                        printWriter.print(this.name);
                        printWriter.println("\\endcsname");
                        printWriter.println("\\expandafter\\global");
                        printWriter.print("\\csname dtldb@");
                        printWriter.print(this.name);
                        printWriter.println("\\endcsname={%");
                        for (TeXObject teXObject : this.dataRows) {
                            printWriter.print("% Start of Row ");
                            printWriter.println(((DataToolEntryRow)teXObject).getRowIndex());
                            printWriter.println("\\db@row@elt@w");
                            printWriter.print("\\db@row@id@w ");
                            printWriter.print(((DataToolEntryRow)teXObject).getRowIndex());
                            printWriter.println("%");
                            printWriter.println("\\db@row@id@end@");
                            object = ((Vector)((Object)teXObject)).iterator();
                            while (object.hasNext()) {
                                DataToolEntry dataToolEntry = (DataToolEntry)object.next();
                                printWriter.print("% Column ");
                                printWriter.println(dataToolEntry.getColumnIndex());
                                printWriter.println("\\db@col@id@w ");
                                printWriter.print(dataToolEntry.getColumnIndex());
                                printWriter.println("%");
                                printWriter.println("\\db@col@id@end@");
                                printWriter.print("\\db@col@elt@w ");
                                printWriter.print(dataToolEntry.getContents().toString(teXParser));
                                printWriter.println("%");
                                printWriter.println("\\db@col@elt@end@");
                                printWriter.println("\\db@col@id@w ");
                                printWriter.print(dataToolEntry.getColumnIndex());
                                printWriter.println("%");
                                printWriter.print("\\db@col@id@end@ % End of Column ");
                                printWriter.println(dataToolEntry.getColumnIndex());
                            }
                            printWriter.print("% End of Row ");
                            printWriter.println(((DataToolEntryRow)teXObject).getRowIndex());
                            printWriter.println("\\db@row@elt@w");
                            printWriter.print("\\db@row@id@w ");
                            printWriter.print(((DataToolEntryRow)teXObject).getRowIndex());
                            printWriter.println("%");
                            printWriter.println("\\db@row@id@end@");
                        }
                        printWriter.println("}%");
                        printWriter.println("\\expandafter\\global");
                        printWriter.println(" \\expandafter\\newcount\\csname dtlrows@");
                        printWriter.print(this.name);
                        printWriter.println("\\endcsname");
                        printWriter.println("\\expandafter\\global");
                        printWriter.println(" \\csname dtlrows@");
                        printWriter.print(this.name);
                        printWriter.println("\\endcsname=");
                        printWriter.print(this.getRowCount());
                        printWriter.println("\\relax");
                        printWriter.println("\\expandafter\\global");
                        printWriter.println(" \\expandafter\\newcount\\csname dtlcols@");
                        printWriter.print(this.name);
                        printWriter.println("\\endcsname");
                        printWriter.println("\\expandafter\\global");
                        printWriter.println(" \\csname dtlcols@");
                        printWriter.print(this.name);
                        printWriter.println("\\endcsname=");
                        printWriter.print(this.getColumnCount());
                        printWriter.println("\\relax");
                        for (TeXObject teXObject : this.headerRow) {
                            printWriter.println("\\expandafter");
                            printWriter.print(" \\gdef\\csname dtl@ci@");
                            printWriter.print(this.name);
                            printWriter.print("@");
                            printWriter.print(((DataToolHeader)teXObject).getColumnLabel());
                            printWriter.print("\\endcsname{");
                            printWriter.print(((DataToolHeader)teXObject).getColumnIndex());
                            printWriter.println("}%");
                        }
                        printWriter.format("\\def\\%s{", "dtllastloadeddb");
                        printWriter.print(this.name);
                        printWriter.println("}%");
                    }
                } else {
                    Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>(this.getColumnCount());
                    for (TeXObject teXObject : this.headerRow) {
                        hashtable.put(((DataToolHeader)teXObject).getColumnIndex(), ((DataToolHeader)teXObject).getColumnLabel());
                    }
                    if (string.equals("3.0")) {
                        Object object;
                        printWriter.print("\\DTLdbProvideData{");
                        printWriter.print(this.name);
                        printWriter.println("}%");
                        for (TeXObject teXObject : this.dataRows) {
                            printWriter.println("\\DTLdbNewRow");
                            object = ((Vector)((Object)teXObject)).iterator();
                            while (object.hasNext()) {
                                DataToolEntry dataToolEntry = (DataToolEntry)object.next();
                                TeXObject teXObject3 = dataToolEntry.getContents();
                                switch (iOExpandOption) {
                                    case FULL: {
                                        teXObject3 = TeXParserUtils.expandFully(teXObject3, teXParser, teXObjectList);
                                        break;
                                    }
                                    case PROTECTED: {
                                        teXObject3 = TeXParserUtils.expandOnce(teXObject3, teXParser, teXObjectList);
                                    }
                                }
                                printWriter.print("\\DTLdbNewEntry{");
                                printWriter.print((String)hashtable.get(dataToolEntry.getColumnIndex()));
                                printWriter.print("}{");
                                printWriter.print(teXObject3.toString(teXParser));
                                printWriter.println("}%");
                            }
                        }
                        if (bl) {
                            for (TeXObject teXObject : this.headerRow) {
                                printWriter.print("\\DTLdbSetHeader{");
                                printWriter.print(((DataToolHeader)teXObject).getColumnLabel());
                                printWriter.print("}{");
                                object = ((DataToolHeader)teXObject).getTitle();
                                if (object == null) {
                                    printWriter.print(((DataToolHeader)teXObject).getColumnLabel());
                                } else {
                                    switch (iOExpandOption) {
                                        case FULL: {
                                            object = TeXParserUtils.expandFully((TeXObject)object, teXParser, teXObjectList);
                                            break;
                                        }
                                        case PROTECTED: {
                                            object = TeXParserUtils.expandOnce((TeXObject)object, teXParser, teXObjectList);
                                        }
                                    }
                                    printWriter.print(object.toString(teXParser));
                                }
                                printWriter.println("}%");
                            }
                        }
                    } else {
                        Object object;
                        printWriter.print("\\DTLnewdb{");
                        printWriter.print(this.name);
                        printWriter.println("}%");
                        for (TeXObject teXObject : this.dataRows) {
                            printWriter.println("\\DTLnewrow{");
                            printWriter.print(this.name);
                            printWriter.println("}%");
                            object = ((Vector)((Object)teXObject)).iterator();
                            while (object.hasNext()) {
                                DataToolEntry dataToolEntry = (DataToolEntry)object.next();
                                TeXObject teXObject4 = dataToolEntry.getContents();
                                switch (iOExpandOption) {
                                    case FULL: {
                                        teXObject4 = TeXParserUtils.expandFully(teXObject4, teXParser, teXObjectList);
                                        break;
                                    }
                                    case PROTECTED: {
                                        teXObject4 = TeXParserUtils.expandOnce(teXObject4, teXParser, teXObjectList);
                                    }
                                }
                                printWriter.print("\\DTLnewdbentry{");
                                printWriter.print(this.name);
                                printWriter.print("}{");
                                printWriter.print((String)hashtable.get(dataToolEntry.getColumnIndex()));
                                printWriter.print("}{");
                                printWriter.print(teXObject4.toString(teXParser));
                                printWriter.println("}%");
                            }
                        }
                        if (bl) {
                            for (TeXObject teXObject : this.headerRow) {
                                printWriter.print("\\DTLsetheader{");
                                printWriter.print(this.name);
                                printWriter.print("}{");
                                printWriter.print(((DataToolHeader)teXObject).getColumnLabel());
                                printWriter.print("}{");
                                object = ((DataToolHeader)teXObject).getTitle();
                                if (object == null) {
                                    printWriter.print(((DataToolHeader)teXObject).getColumnLabel());
                                } else {
                                    switch (iOExpandOption) {
                                        case FULL: {
                                            object = TeXParserUtils.expandFully((TeXObject)object, teXParser, teXObjectList);
                                            break;
                                        }
                                        case PROTECTED: {
                                            object = TeXParserUtils.expandOnce((TeXObject)object, teXParser, teXObjectList);
                                        }
                                    }
                                    printWriter.print(object.toString(teXParser));
                                }
                                printWriter.println("}%");
                            }
                        }
                        printWriter.format("\\def\\%s{", "dtllastloadeddb");
                        printWriter.print(this.name);
                        printWriter.println("}%");
                    }
                }
            } else {
                Object object;
                int n = iOSettings.getSeparator();
                if (bl) {
                    for (int i = 0; i < this.headerRow.size(); ++i) {
                        TeXObject teXObject;
                        TeXObject teXObject5 = (DataToolHeader)this.headerRow.get(i);
                        if (i > 0) {
                            printWriter.write(n);
                        }
                        if ((teXObject = ((DataToolHeader)teXObject5).getTitle()) == null) {
                            object = ((DataToolHeader)teXObject5).getColumnLabel();
                        } else {
                            switch (iOExpandOption) {
                                case FULL: {
                                    teXObject = TeXParserUtils.expandFully(teXObject, teXParser, teXObjectList);
                                    break;
                                }
                                case PROTECTED: {
                                    teXObject = TeXParserUtils.expandOnce(teXObject, teXParser, teXObjectList);
                                }
                            }
                            object = teXObject.toString(teXParser);
                        }
                        printWriter.print(this.prepareCSV((String)object, iOSettings));
                    }
                    printWriter.println();
                }
                for (TeXObject teXObject5 : this.dataRows) {
                    for (int i = 0; i < ((Vector)((Object)teXObject5)).size(); ++i) {
                        object = (DataToolEntry)((Vector)((Object)teXObject5)).get(i);
                        if (i > 0) {
                            printWriter.write(n);
                        }
                        TeXObject teXObject = ((DataToolEntry)object).getContents();
                        switch (iOExpandOption) {
                            case FULL: {
                                teXObject = TeXParserUtils.expandFully(teXObject, teXParser, teXObjectList);
                                break;
                            }
                            case PROTECTED: {
                                teXObject = TeXParserUtils.expandOnce(teXObject, teXParser, teXObjectList);
                            }
                        }
                        String string2 = teXObject.toString(teXParser);
                        printWriter.print(this.prepareCSV(string2, iOSettings));
                    }
                    printWriter.println();
                }
            }
        }
    }

    protected CharSequence prepareCSV(String string, IOSettings iOSettings) {
        int n = iOSettings.getDelimiter();
        int n2 = iOSettings.getSeparator();
        AddDelimiterOption addDelimiterOption = iOSettings.getAddDelimiterOption();
        EscapeCharsOption escapeCharsOption = iOSettings.getEscapeCharsOption();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        int n3 = 0;
        while (n3 < string.length()) {
            int n4 = string.codePointAt(n3);
            n3 += Character.charCount(n4);
            if (n4 == n2) {
                bl = true;
            } else if (n4 == n) {
                if (escapeCharsOption == EscapeCharsOption.DOUBLE_DELIM) {
                    stringBuilder.appendCodePoint(n);
                } else if (escapeCharsOption != EscapeCharsOption.NONE) {
                    stringBuilder.appendCodePoint(92);
                }
            } else if (n4 == 92) {
                if (escapeCharsOption == EscapeCharsOption.ESC_DELIM_BKSL) {
                    stringBuilder.appendCodePoint(92);
                }
            } else if (n4 == 10 || n4 == 13 || n4 == 12) {
                if (addDelimiterOption == AddDelimiterOption.NEVER) {
                    n4 = 32;
                } else {
                    bl = true;
                }
            }
            stringBuilder.appendCodePoint(n4);
        }
        if (addDelimiterOption == AddDelimiterOption.ALWAYS || bl && addDelimiterOption == AddDelimiterOption.DETECT) {
            string = stringBuilder.toString();
            stringBuilder.setLength(0);
            stringBuilder.appendCodePoint(n);
            stringBuilder.append(string);
            stringBuilder.appendCodePoint(n);
        }
        return stringBuilder;
    }

    public String toString() {
        return String.format("%s[name=%s,header=%s,data=%s]", this.getClass().getSimpleName(), this.name, this.headerRow, this.dataRows);
    }
}

