﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/mediapackage-vod/MediaPackageVod_EXPORTS.h>
#include <aws/mediapackage-vod/model/EgressEndpoint.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace MediaPackageVod {
namespace Model {
class CreateAssetResult {
 public:
  AWS_MEDIAPACKAGEVOD_API CreateAssetResult() = default;
  AWS_MEDIAPACKAGEVOD_API CreateAssetResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_MEDIAPACKAGEVOD_API CreateAssetResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * The ARN of the Asset.
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  CreateAssetResult& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The time the Asset was initially submitted for Ingest.
   */
  inline const Aws::String& GetCreatedAt() const { return m_createdAt; }
  template <typename CreatedAtT = Aws::String>
  void SetCreatedAt(CreatedAtT&& value) {
    m_createdAtHasBeenSet = true;
    m_createdAt = std::forward<CreatedAtT>(value);
  }
  template <typename CreatedAtT = Aws::String>
  CreateAssetResult& WithCreatedAt(CreatedAtT&& value) {
    SetCreatedAt(std::forward<CreatedAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The list of egress endpoints available for the Asset.
   */
  inline const Aws::Vector<EgressEndpoint>& GetEgressEndpoints() const { return m_egressEndpoints; }
  template <typename EgressEndpointsT = Aws::Vector<EgressEndpoint>>
  void SetEgressEndpoints(EgressEndpointsT&& value) {
    m_egressEndpointsHasBeenSet = true;
    m_egressEndpoints = std::forward<EgressEndpointsT>(value);
  }
  template <typename EgressEndpointsT = Aws::Vector<EgressEndpoint>>
  CreateAssetResult& WithEgressEndpoints(EgressEndpointsT&& value) {
    SetEgressEndpoints(std::forward<EgressEndpointsT>(value));
    return *this;
  }
  template <typename EgressEndpointsT = EgressEndpoint>
  CreateAssetResult& AddEgressEndpoints(EgressEndpointsT&& value) {
    m_egressEndpointsHasBeenSet = true;
    m_egressEndpoints.emplace_back(std::forward<EgressEndpointsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The unique identifier for the Asset.
   */
  inline const Aws::String& GetId() const { return m_id; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  CreateAssetResult& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The ID of the PackagingGroup for the Asset.
   */
  inline const Aws::String& GetPackagingGroupId() const { return m_packagingGroupId; }
  template <typename PackagingGroupIdT = Aws::String>
  void SetPackagingGroupId(PackagingGroupIdT&& value) {
    m_packagingGroupIdHasBeenSet = true;
    m_packagingGroupId = std::forward<PackagingGroupIdT>(value);
  }
  template <typename PackagingGroupIdT = Aws::String>
  CreateAssetResult& WithPackagingGroupId(PackagingGroupIdT&& value) {
    SetPackagingGroupId(std::forward<PackagingGroupIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The resource ID to include in SPEKE key requests.
   */
  inline const Aws::String& GetResourceId() const { return m_resourceId; }
  template <typename ResourceIdT = Aws::String>
  void SetResourceId(ResourceIdT&& value) {
    m_resourceIdHasBeenSet = true;
    m_resourceId = std::forward<ResourceIdT>(value);
  }
  template <typename ResourceIdT = Aws::String>
  CreateAssetResult& WithResourceId(ResourceIdT&& value) {
    SetResourceId(std::forward<ResourceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * ARN of the source object in S3.
   */
  inline const Aws::String& GetSourceArn() const { return m_sourceArn; }
  template <typename SourceArnT = Aws::String>
  void SetSourceArn(SourceArnT&& value) {
    m_sourceArnHasBeenSet = true;
    m_sourceArn = std::forward<SourceArnT>(value);
  }
  template <typename SourceArnT = Aws::String>
  CreateAssetResult& WithSourceArn(SourceArnT&& value) {
    SetSourceArn(std::forward<SourceArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The IAM role_arn used to access the source S3 bucket.
   */
  inline const Aws::String& GetSourceRoleArn() const { return m_sourceRoleArn; }
  template <typename SourceRoleArnT = Aws::String>
  void SetSourceRoleArn(SourceRoleArnT&& value) {
    m_sourceRoleArnHasBeenSet = true;
    m_sourceRoleArn = std::forward<SourceRoleArnT>(value);
  }
  template <typename SourceRoleArnT = Aws::String>
  CreateAssetResult& WithSourceRoleArn(SourceRoleArnT&& value) {
    SetSourceRoleArn(std::forward<SourceRoleArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  CreateAssetResult& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  CreateAssetResult& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateAssetResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;
  bool m_arnHasBeenSet = false;

  Aws::String m_createdAt;
  bool m_createdAtHasBeenSet = false;

  Aws::Vector<EgressEndpoint> m_egressEndpoints;
  bool m_egressEndpointsHasBeenSet = false;

  Aws::String m_id;
  bool m_idHasBeenSet = false;

  Aws::String m_packagingGroupId;
  bool m_packagingGroupIdHasBeenSet = false;

  Aws::String m_resourceId;
  bool m_resourceIdHasBeenSet = false;

  Aws::String m_sourceArn;
  bool m_sourceArnHasBeenSet = false;

  Aws::String m_sourceRoleArn;
  bool m_sourceRoleArnHasBeenSet = false;

  Aws::Map<Aws::String, Aws::String> m_tags;
  bool m_tagsHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace MediaPackageVod
}  // namespace Aws
