﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appconfig/AppConfig_EXPORTS.h>
#include <aws/appconfig/model/EnvironmentState.h>
#include <aws/appconfig/model/Monitor.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace AppConfig {
namespace Model {
class CreateEnvironmentResult {
 public:
  AWS_APPCONFIG_API CreateEnvironmentResult() = default;
  AWS_APPCONFIG_API CreateEnvironmentResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_APPCONFIG_API CreateEnvironmentResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The application ID.</p>
   */
  inline const Aws::String& GetApplicationId() const { return m_applicationId; }
  template <typename ApplicationIdT = Aws::String>
  void SetApplicationId(ApplicationIdT&& value) {
    m_applicationIdHasBeenSet = true;
    m_applicationId = std::forward<ApplicationIdT>(value);
  }
  template <typename ApplicationIdT = Aws::String>
  CreateEnvironmentResult& WithApplicationId(ApplicationIdT&& value) {
    SetApplicationId(std::forward<ApplicationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The environment ID.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  CreateEnvironmentResult& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the environment.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  CreateEnvironmentResult& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description of the environment.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  CreateEnvironmentResult& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The state of the environment. An environment can be in one of the following
   * states: <code>READY_FOR_DEPLOYMENT</code>, <code>DEPLOYING</code>,
   * <code>ROLLING_BACK</code>, or <code>ROLLED_BACK</code> </p>
   */
  inline EnvironmentState GetState() const { return m_state; }
  inline void SetState(EnvironmentState value) {
    m_stateHasBeenSet = true;
    m_state = value;
  }
  inline CreateEnvironmentResult& WithState(EnvironmentState value) {
    SetState(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Amazon CloudWatch alarms monitored during the deployment.</p>
   */
  inline const Aws::Vector<Monitor>& GetMonitors() const { return m_monitors; }
  template <typename MonitorsT = Aws::Vector<Monitor>>
  void SetMonitors(MonitorsT&& value) {
    m_monitorsHasBeenSet = true;
    m_monitors = std::forward<MonitorsT>(value);
  }
  template <typename MonitorsT = Aws::Vector<Monitor>>
  CreateEnvironmentResult& WithMonitors(MonitorsT&& value) {
    SetMonitors(std::forward<MonitorsT>(value));
    return *this;
  }
  template <typename MonitorsT = Monitor>
  CreateEnvironmentResult& AddMonitors(MonitorsT&& value) {
    m_monitorsHasBeenSet = true;
    m_monitors.emplace_back(std::forward<MonitorsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateEnvironmentResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_applicationId;

  Aws::String m_id;

  Aws::String m_name;

  Aws::String m_description;

  EnvironmentState m_state{EnvironmentState::NOT_SET};

  Aws::Vector<Monitor> m_monitors;

  Aws::String m_requestId;
  bool m_applicationIdHasBeenSet = false;
  bool m_idHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_stateHasBeenSet = false;
  bool m_monitorsHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace AppConfig
}  // namespace Aws
