﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ecs/ECSRequest.h>
#include <aws/ecs/ECS_EXPORTS.h>

#include <utility>

namespace Aws {
namespace ECS {
namespace Model {

/**
 */
class DeregisterTaskDefinitionRequest : public ECSRequest {
 public:
  AWS_ECS_API DeregisterTaskDefinitionRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeregisterTaskDefinition"; }

  AWS_ECS_API Aws::String SerializePayload() const override;

  AWS_ECS_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The <code>family</code> and <code>revision</code>
   * (<code>family:revision</code>) or full Amazon Resource Name (ARN) of the task
   * definition to deregister. You must specify a <code>revision</code>.</p>
   */
  inline const Aws::String& GetTaskDefinition() const { return m_taskDefinition; }
  inline bool TaskDefinitionHasBeenSet() const { return m_taskDefinitionHasBeenSet; }
  template <typename TaskDefinitionT = Aws::String>
  void SetTaskDefinition(TaskDefinitionT&& value) {
    m_taskDefinitionHasBeenSet = true;
    m_taskDefinition = std::forward<TaskDefinitionT>(value);
  }
  template <typename TaskDefinitionT = Aws::String>
  DeregisterTaskDefinitionRequest& WithTaskDefinition(TaskDefinitionT&& value) {
    SetTaskDefinition(std::forward<TaskDefinitionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_taskDefinition;
  bool m_taskDefinitionHasBeenSet = false;
};

}  // namespace Model
}  // namespace ECS
}  // namespace Aws
