﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/lakeformation/LakeFormation_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace LakeFormation {
namespace Model {

/**
 * <p>An object to delete from the governed table.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DeleteObjectInput">AWS
 * API Reference</a></p>
 */
class DeleteObjectInput {
 public:
  AWS_LAKEFORMATION_API DeleteObjectInput() = default;
  AWS_LAKEFORMATION_API DeleteObjectInput(Aws::Utils::Json::JsonView jsonValue);
  AWS_LAKEFORMATION_API DeleteObjectInput& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_LAKEFORMATION_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The Amazon S3 location of the object to delete.</p>
   */
  inline const Aws::String& GetUri() const { return m_uri; }
  inline bool UriHasBeenSet() const { return m_uriHasBeenSet; }
  template <typename UriT = Aws::String>
  void SetUri(UriT&& value) {
    m_uriHasBeenSet = true;
    m_uri = std::forward<UriT>(value);
  }
  template <typename UriT = Aws::String>
  DeleteObjectInput& WithUri(UriT&& value) {
    SetUri(std::forward<UriT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon S3 ETag of the object. Returned by <code>GetTableObjects</code>
   * for validation and used to identify changes to the underlying data.</p>
   */
  inline const Aws::String& GetETag() const { return m_eTag; }
  inline bool ETagHasBeenSet() const { return m_eTagHasBeenSet; }
  template <typename ETagT = Aws::String>
  void SetETag(ETagT&& value) {
    m_eTagHasBeenSet = true;
    m_eTag = std::forward<ETagT>(value);
  }
  template <typename ETagT = Aws::String>
  DeleteObjectInput& WithETag(ETagT&& value) {
    SetETag(std::forward<ETagT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of partition values for the object. A value must be specified for each
   * partition key associated with the governed table.</p>
   */
  inline const Aws::Vector<Aws::String>& GetPartitionValues() const { return m_partitionValues; }
  inline bool PartitionValuesHasBeenSet() const { return m_partitionValuesHasBeenSet; }
  template <typename PartitionValuesT = Aws::Vector<Aws::String>>
  void SetPartitionValues(PartitionValuesT&& value) {
    m_partitionValuesHasBeenSet = true;
    m_partitionValues = std::forward<PartitionValuesT>(value);
  }
  template <typename PartitionValuesT = Aws::Vector<Aws::String>>
  DeleteObjectInput& WithPartitionValues(PartitionValuesT&& value) {
    SetPartitionValues(std::forward<PartitionValuesT>(value));
    return *this;
  }
  template <typename PartitionValuesT = Aws::String>
  DeleteObjectInput& AddPartitionValues(PartitionValuesT&& value) {
    m_partitionValuesHasBeenSet = true;
    m_partitionValues.emplace_back(std::forward<PartitionValuesT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_uri;

  Aws::String m_eTag;

  Aws::Vector<Aws::String> m_partitionValues;
  bool m_uriHasBeenSet = false;
  bool m_eTagHasBeenSet = false;
  bool m_partitionValuesHasBeenSet = false;
};

}  // namespace Model
}  // namespace LakeFormation
}  // namespace Aws
