﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/migrationhuborchestrator/MigrationHubOrchestrator_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace MigrationHubOrchestrator {
namespace Model {

/**
 * <p>The summary of the step group in the template.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/TemplateStepGroupSummary">AWS
 * API Reference</a></p>
 */
class TemplateStepGroupSummary {
 public:
  AWS_MIGRATIONHUBORCHESTRATOR_API TemplateStepGroupSummary() = default;
  AWS_MIGRATIONHUBORCHESTRATOR_API TemplateStepGroupSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_MIGRATIONHUBORCHESTRATOR_API TemplateStepGroupSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_MIGRATIONHUBORCHESTRATOR_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ID of the step group.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  TemplateStepGroupSummary& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the step group.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  TemplateStepGroupSummary& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The previous step group.</p>
   */
  inline const Aws::Vector<Aws::String>& GetPrevious() const { return m_previous; }
  inline bool PreviousHasBeenSet() const { return m_previousHasBeenSet; }
  template <typename PreviousT = Aws::Vector<Aws::String>>
  void SetPrevious(PreviousT&& value) {
    m_previousHasBeenSet = true;
    m_previous = std::forward<PreviousT>(value);
  }
  template <typename PreviousT = Aws::Vector<Aws::String>>
  TemplateStepGroupSummary& WithPrevious(PreviousT&& value) {
    SetPrevious(std::forward<PreviousT>(value));
    return *this;
  }
  template <typename PreviousT = Aws::String>
  TemplateStepGroupSummary& AddPrevious(PreviousT&& value) {
    m_previousHasBeenSet = true;
    m_previous.emplace_back(std::forward<PreviousT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The next step group.</p>
   */
  inline const Aws::Vector<Aws::String>& GetNext() const { return m_next; }
  inline bool NextHasBeenSet() const { return m_nextHasBeenSet; }
  template <typename NextT = Aws::Vector<Aws::String>>
  void SetNext(NextT&& value) {
    m_nextHasBeenSet = true;
    m_next = std::forward<NextT>(value);
  }
  template <typename NextT = Aws::Vector<Aws::String>>
  TemplateStepGroupSummary& WithNext(NextT&& value) {
    SetNext(std::forward<NextT>(value));
    return *this;
  }
  template <typename NextT = Aws::String>
  TemplateStepGroupSummary& AddNext(NextT&& value) {
    m_nextHasBeenSet = true;
    m_next.emplace_back(std::forward<NextT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;

  Aws::String m_name;

  Aws::Vector<Aws::String> m_previous;

  Aws::Vector<Aws::String> m_next;
  bool m_idHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_previousHasBeenSet = false;
  bool m_nextHasBeenSet = false;
};

}  // namespace Model
}  // namespace MigrationHubOrchestrator
}  // namespace Aws
