﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/mturk-requester/MTurk_EXPORTS.h>
#include <aws/mturk-requester/model/Assignment.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace MTurk {
namespace Model {
class ListAssignmentsForHITResult {
 public:
  AWS_MTURK_API ListAssignmentsForHITResult() = default;
  AWS_MTURK_API ListAssignmentsForHITResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_MTURK_API ListAssignmentsForHITResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{

  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListAssignmentsForHITResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The number of assignments on the page in the filtered results list,
   * equivalent to the number of assignments returned by this call.</p>
   */
  inline int GetNumResults() const { return m_numResults; }
  inline void SetNumResults(int value) {
    m_numResultsHasBeenSet = true;
    m_numResults = value;
  }
  inline ListAssignmentsForHITResult& WithNumResults(int value) {
    SetNumResults(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The collection of Assignment data structures returned by this call.</p>
   */
  inline const Aws::Vector<Assignment>& GetAssignments() const { return m_assignments; }
  template <typename AssignmentsT = Aws::Vector<Assignment>>
  void SetAssignments(AssignmentsT&& value) {
    m_assignmentsHasBeenSet = true;
    m_assignments = std::forward<AssignmentsT>(value);
  }
  template <typename AssignmentsT = Aws::Vector<Assignment>>
  ListAssignmentsForHITResult& WithAssignments(AssignmentsT&& value) {
    SetAssignments(std::forward<AssignmentsT>(value));
    return *this;
  }
  template <typename AssignmentsT = Assignment>
  ListAssignmentsForHITResult& AddAssignments(AssignmentsT&& value) {
    m_assignmentsHasBeenSet = true;
    m_assignments.emplace_back(std::forward<AssignmentsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListAssignmentsForHITResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;

  int m_numResults{0};

  Aws::Vector<Assignment> m_assignments;

  Aws::String m_requestId;
  bool m_nextTokenHasBeenSet = false;
  bool m_numResultsHasBeenSet = false;
  bool m_assignmentsHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace MTurk
}  // namespace Aws
