/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql;

import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;

public class SQLControlCommand
implements SQLScriptElement {
    private final DBPDataSource dataSource;
    private final String text;
    private final String command;
    private final String commandId;
    private final String parameter;
    private final int offset;
    private final int length;
    private Object data;
    private boolean emptyCommand;
    private final Map<String, String> parameters;

    public SQLControlCommand(@Nullable DBPDataSource dataSource, @NotNull String text, @Nullable String commandId, int offset, int length, @NotNull Map<String, String> parameters) {
        this.dataSource = dataSource;
        this.text = text;
        this.command = commandId;
        this.commandId = commandId;
        this.parameter = null;
        this.offset = offset;
        this.length = length;
        this.parameters = parameters;
    }

    public SQLControlCommand(DBPDataSource dataSource, SQLSyntaxManager syntaxManager, String text, String commandId, int offset, int length, boolean emptyCommand) {
        this.dataSource = dataSource;
        this.text = text;
        String multilineCommandPrefix = syntaxManager.getControlCommandPrefix().repeat(2);
        if (text.startsWith(multilineCommandPrefix)) {
            text = text.substring(multilineCommandPrefix.length(), text.length() - multilineCommandPrefix.length());
        } else if (text.startsWith(syntaxManager.getControlCommandPrefix())) {
            text = text.substring(syntaxManager.getControlCommandPrefix().length());
        }
        int divPos = -1;
        int i = 0;
        while (i < text.length()) {
            if (!Character.isLetterOrDigit(text.charAt(i))) {
                divPos = i;
                break;
            }
            ++i;
        }
        this.command = divPos == -1 ? text : text.substring(0, divPos);
        this.parameter = divPos == -1 ? null : text.substring(divPos + 1).trim();
        this.offset = offset;
        this.length = length;
        this.emptyCommand = emptyCommand;
        this.commandId = commandId == null ? this.command : commandId;
        this.parameters = null;
    }

    public DBPDataSourceContainer getDataSourceContainer() {
        return this.dataSource == null ? null : this.dataSource.getContainer();
    }

    @Override
    @Nullable
    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    @NotNull
    public String getOriginalText() {
        return this.command;
    }

    @Override
    @NotNull
    public String getText() {
        return this.text;
    }

    public String getCommand() {
        return this.command;
    }

    public String getCommandId() {
        return this.commandId;
    }

    public String getParameter() {
        return this.parameter;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean isEmptyCommand() {
        return this.emptyCommand;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public void setData(Object data) {
        this.data = data;
    }

    @Override
    public void reset() {
    }

    public String toString() {
        return this.text;
    }
}

