/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.gradle.api.artifacts.ComponentMetadata;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ModuleVersionIdentifierSerializer;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.UserProvidedMetadata;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.AttributeContainerSerializer;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.Build.class})
public class SuppliedComponentMetadataSerializer
extends AbstractSerializer<ComponentMetadata> {
    private final ModuleVersionIdentifierSerializer moduleVersionIdentifierSerializer;
    private final AttributeContainerSerializer attributeContainerSerializer;

    public SuppliedComponentMetadataSerializer(ModuleVersionIdentifierSerializer moduleVersionIdentifierSerializer, AttributeContainerSerializer attributeContainerSerializer) {
        this.moduleVersionIdentifierSerializer = moduleVersionIdentifierSerializer;
        this.attributeContainerSerializer = attributeContainerSerializer;
    }

    public ComponentMetadata read(Decoder decoder) throws Exception {
        ModuleVersionIdentifier id = this.moduleVersionIdentifierSerializer.read(decoder);
        ImmutableAttributes attributes = this.attributeContainerSerializer.read(decoder);
        List<String> statusScheme = this.readStatusScheme(decoder);
        return new UserProvidedMetadata(id, statusScheme, attributes.asImmutable());
    }

    public void write(Encoder encoder, ComponentMetadata md) throws Exception {
        this.moduleVersionIdentifierSerializer.write(encoder, md.getId());
        this.attributeContainerSerializer.write(encoder, md.getAttributes());
        this.checkChangingFlag(md);
        this.writeStatusScheme(encoder, md);
    }

    private void checkChangingFlag(ComponentMetadata md) {
        boolean changing = md.isChanging();
        if (changing) {
            throw new UnsupportedOperationException("User-supplied metadata shouldn't have changing=true");
        }
    }

    private void writeStatusScheme(Encoder encoder, ComponentMetadata md) throws IOException {
        List statusScheme = md.getStatusScheme();
        encoder.writeSmallInt(statusScheme.size());
        for (String s : statusScheme) {
            encoder.writeString((CharSequence)s);
        }
    }

    private List<String> readStatusScheme(Decoder decoder) throws IOException {
        int size = decoder.readSmallInt();
        ImmutableList.Builder scheme = ImmutableList.builder();
        for (int i = 0; i < size; ++i) {
            scheme.add((Object)decoder.readString());
        }
        return scheme.build();
    }
}

