/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.psi.impl.light.LightParameterListBuilder;
import icons.JetgroovyIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrModifierListUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;

public class GrAccessorMethodImpl
extends LightMethodBuilder
implements GrAccessorMethod {
    @NotNull
    private final GrField myProperty;
    private final boolean myIsSetter;

    public GrAccessorMethodImpl(@NotNull GrField property, boolean isSetter, String name) {
        if (property == null) {
            GrAccessorMethodImpl.$$$reportNull$$$0(0);
        }
        this(property, isSetter, name, null);
    }

    public GrAccessorMethodImpl(@NotNull GrField property, boolean isSetter, String name, @Nullable Integer modifierMask) {
        if (property == null) {
            GrAccessorMethodImpl.$$$reportNull$$$0(1);
        }
        super(property.getManager(), (Language)GroovyLanguage.INSTANCE, name, (PsiParameterList)new LightParameterListBuilder(property.getManager(), (Language)GroovyLanguage.INSTANCE), (PsiModifierList)new LightModifierList(property.getManager()){

            public String getText() {
                String[] modifiers = this.getModifiers();
                if (modifiers.length == 0) {
                    return "";
                }
                if (modifiers.length == 1) {
                    return modifiers[0];
                }
                return StringUtil.join((String[])modifiers, (String)" ");
            }
        });
        this.myProperty = property;
        this.myIsSetter = isSetter;
        if (this.myIsSetter) {
            PsiType type = this.myProperty.getDeclaredType();
            if (type == null) {
                type = TypesUtil.getJavaLangObject(this.myProperty);
            }
            this.addParameter(this.myProperty.getName(), type);
        }
        this.setMethodReturnType((PsiType)(this.myIsSetter ? PsiTypes.voidType() : this.myProperty.getType()));
        if (modifierMask == null) {
            this.addModifier("public");
        } else if ((modifierMask & 1) != 0) {
            this.addModifier("public");
        } else if ((modifierMask & 4) != 0) {
            this.addModifier("protected");
        } else if ((modifierMask & 2) != 0) {
            this.addModifier("private");
        }
        GrModifierList modifierList = this.myProperty.getModifierList();
        if (modifierList != null && GrModifierListUtil.hasModifierProperty(modifierList, "static", false)) {
            this.addModifier("static");
        } else if (modifierList != null && GrModifierListUtil.hasModifierProperty(modifierList, "final", false)) {
            this.addModifier("final");
        }
        if (modifierList != null && GrModifierListUtil.hasModifierProperty(modifierList, "abstract", false) && GrTraitUtil.isTrait(this.myProperty.getContainingClass())) {
            this.addModifier("abstract");
        }
        this.setNavigationElement(property);
        this.setBaseIcon(JetgroovyIcons.Groovy.Property);
        this.setContainingClass(this.myProperty.getContainingClass());
        this.setMethodKind("AccessorMethod");
        this.setOriginInfo("synthetic accessor for '" + this.myProperty.getName() + "'");
    }

    @Override
    @Nullable
    public PsiType getInferredReturnType() {
        if (this.myIsSetter) {
            return PsiTypes.voidType();
        }
        return this.myProperty.getTypeGroovy();
    }

    @Override
    public boolean isSetter() {
        return this.myIsSetter;
    }

    public PsiElement copy() {
        String modifiers = this.getModifierList().getText();
        Object params = this.myIsSetter ? "(" + this.myProperty.getName() + ")" : "()";
        return GroovyPsiElementFactory.getInstance(this.getProject()).createMethodFromText(modifiers + " " + this.getName() + (String)params + "{}");
    }

    @Override
    @NotNull
    public GrField getProperty() {
        GrField grField = this.myProperty;
        if (grField == null) {
            GrAccessorMethodImpl.$$$reportNull$$$0(2);
        }
        return grField;
    }

    public boolean isEquivalentTo(PsiElement another) {
        if (another == this) {
            return true;
        }
        if (!(another instanceof GrAccessorMethod)) {
            return false;
        }
        if (!((GrAccessorMethod)another).getName().equals(this.getName())) {
            return false;
        }
        return this.getManager().areElementsEquivalent((PsiElement)this.myProperty, (PsiElement)((GrAccessorMethod)another).getProperty());
    }

    @NotNull
    public PsiElement getPrototype() {
        GrField grField = this.getProperty();
        if (grField == null) {
            GrAccessorMethodImpl.$$$reportNull$$$0(3);
        }
        return grField;
    }

    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            GrAccessorMethodImpl.$$$reportNull$$$0(4);
        }
        if (GrTraitUtil.isTrait(this.getContainingClass())) {
            if ("abstract".equals(name)) {
                return true;
            }
            if ("final".equals(name)) {
                return false;
            }
        }
        return super.hasModifierProperty(name);
    }

    @NotNull
    public LightModifierList getModifierList() {
        LightModifierList lightModifierList = (LightModifierList)super.getModifierList();
        if (lightModifierList == null) {
            GrAccessorMethodImpl.$$$reportNull$$$0(5);
        }
        return lightModifierList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrAccessorMethodImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrAccessorMethodImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperty";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrototype";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifierList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5 -> new IllegalStateException(string);
        };
    }
}

