/*
 * Decompiled with CFR 0.152.
 */
package io.github.smiley4.schemakenerator.jsonschema.jsonDsl;

import io.github.smiley4.schemakenerator.jsonschema.jsonDsl.JsonArray;
import io.github.smiley4.schemakenerator.jsonschema.jsonDsl.JsonBooleanValue;
import io.github.smiley4.schemakenerator.jsonschema.jsonDsl.JsonNode;
import io.github.smiley4.schemakenerator.jsonschema.jsonDsl.JsonNumericValue;
import io.github.smiley4.schemakenerator.jsonschema.jsonDsl.JsonTextValue;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0004J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0001H\u0016J\u0013\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\u0015\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0003J\u001f\u0010\u001b\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0001J\t\u0010\u001c\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001d"}, d2={"Lio/github/smiley4/schemakenerator/jsonschema/jsonDsl/JsonObject;", "Lio/github/smiley4/schemakenerator/jsonschema/jsonDsl/JsonNode;", "properties", "", "", "<init>", "(Ljava/util/Map;)V", "getProperties", "()Ljava/util/Map;", "getText", "propertyName", "getNumber", "", "getBool", "", "getArray", "Lio/github/smiley4/schemakenerator/jsonschema/jsonDsl/JsonArray;", "getObject", "prettyPrint", "level", "", "copyNode", "equals", "other", "", "hashCode", "component1", "copy", "toString", "schema-kenerator-jsonschema"})
@SourceDebugExtension(value={"SMAP\nJsonNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonNode.kt\nio/github/smiley4/schemakenerator/jsonschema/jsonDsl/JsonObject\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,197:1\n1872#2,3:198\n1246#2,4:203\n462#3:201\n412#3:202\n*S KotlinDebug\n*F\n+ 1 JsonNode.kt\nio/github/smiley4/schemakenerator/jsonschema/jsonDsl/JsonObject\n*L\n77#1:198,3\n87#1:203,4\n87#1:201\n87#1:202\n*E\n"})
public final class JsonObject
implements JsonNode {
    @NotNull
    private final Map<String, JsonNode> properties;

    public JsonObject(@NotNull Map<String, JsonNode> properties) {
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        this.properties = properties;
    }

    @NotNull
    public final Map<String, JsonNode> getProperties() {
        return this.properties;
    }

    @NotNull
    public final String getText(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        JsonNode prop = this.properties.get(propertyName);
        if (prop instanceof JsonTextValue) {
            return (String)((JsonTextValue)prop).getValue();
        }
        throw new NoSuchElementException("Property '" + propertyName + "' is not a " + Reflection.getOrCreateKotlinClass(JsonTextValue.class).getSimpleName());
    }

    @NotNull
    public final Number getNumber(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        JsonNode prop = this.properties.get(propertyName);
        if (prop instanceof JsonNumericValue) {
            return (Number)((JsonNumericValue)prop).getValue();
        }
        throw new NoSuchElementException("Property '" + propertyName + "' is not a " + Reflection.getOrCreateKotlinClass(JsonNumericValue.class).getSimpleName());
    }

    public final boolean getBool(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        JsonNode prop = this.properties.get(propertyName);
        if (prop instanceof JsonBooleanValue) {
            return (Boolean)((JsonBooleanValue)prop).getValue();
        }
        throw new NoSuchElementException("Property '" + propertyName + "' is not a " + Reflection.getOrCreateKotlinClass(JsonBooleanValue.class).getSimpleName());
    }

    @NotNull
    public final JsonArray getArray(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        JsonNode prop = this.properties.get(propertyName);
        if (prop instanceof JsonArray) {
            return (JsonArray)prop;
        }
        throw new NoSuchElementException("Property '" + propertyName + "' is not a " + Reflection.getOrCreateKotlinClass(JsonArray.class).getSimpleName());
    }

    @NotNull
    public final JsonObject getObject(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        JsonNode prop = this.properties.get(propertyName);
        if (prop instanceof JsonObject) {
            return (JsonObject)prop;
        }
        throw new NoSuchElementException("Property '" + propertyName + "' is not a " + Reflection.getOrCreateKotlinClass(JsonObject.class).getSimpleName());
    }

    @Override
    @NotNull
    public String prettyPrint(int level) {
        StringBuilder stringBuilder;
        if (this.properties.isEmpty()) {
            return "{}";
        }
        StringBuilder $this$prettyPrint_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$prettyPrint_u24lambda_u241.append("{");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        Iterable $this$forEachIndexed$iv = this.properties.entrySet();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Map.Entry entry = (Map.Entry)item$iv;
            int index = n;
            boolean bl2 = false;
            String key = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            boolean isLast = index == this.properties.size() - 1;
            StringBuilder stringBuilder3 = $this$prettyPrint_u24lambda_u241.append(this.indent(level + 1) + "\"" + key + "\": " + value.prettyPrint(level + 1) + (isLast ? "" : ","));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        }
        $this$prettyPrint_u24lambda_u241.append(this.indent(level) + "}");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsonNode copyNode() {
        void $this$mapValuesTo$iv$iv;
        Map<String, JsonNode> $this$mapValues$iv = this.properties;
        boolean $i$f$mapValues = false;
        Map<String, JsonNode> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            JsonNode value = (JsonNode)entry2.getValue();
            JsonNode jsonNode = value.copyNode();
            map3.put(k, jsonNode);
        }
        Map map4 = MapsKt.toMutableMap((Map)destination$iv$iv);
        return new JsonObject(map4);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof JsonObject && Intrinsics.areEqual(((JsonObject)other).properties, this.properties);
    }

    public int hashCode() {
        return ((Object)this.properties).hashCode();
    }

    @NotNull
    public final Map<String, JsonNode> component1() {
        return this.properties;
    }

    @NotNull
    public final JsonObject copy(@NotNull Map<String, JsonNode> properties) {
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        return new JsonObject(properties);
    }

    public static /* synthetic */ JsonObject copy$default(JsonObject jsonObject, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            map = jsonObject.properties;
        }
        return jsonObject.copy(map);
    }

    @NotNull
    public String toString() {
        return "JsonObject(properties=" + this.properties + ")";
    }

    @Override
    @NotNull
    public String indent(int level) {
        return JsonNode.DefaultImpls.indent(this, level);
    }
}

