/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.gestures;

import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVector1D;
import androidx.compose.animation.core.AnimationVector2D;
import androidx.compose.animation.core.TwoWayConverter;
import androidx.compose.animation.core.VectorConvertersKt;
import androidx.compose.animation.core.VectorizedAnimationSpec;
import androidx.compose.animation.core.VectorizedFiniteAnimationSpec;
import androidx.compose.foundation.gestures.AnimationData;
import androidx.compose.ui.geometry.Offset;
import kotlin.Metadata;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B1\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001\u00a2\u0006\u0004\b\b\u0010\tJ,\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\f0\u000b\"\b\b\u0000\u0010\f*\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\f0\u000fH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Landroidx/compose/foundation/gestures/DelegatingAnimationSpec;", "Landroidx/compose/animation/core/AnimationSpec;", "Landroidx/compose/foundation/gestures/AnimationData;", "zoomAnimationSpec", "", "offsetAnimationSpec", "Landroidx/compose/ui/geometry/Offset;", "rotationAnimationSpec", "<init>", "(Landroidx/compose/animation/core/AnimationSpec;Landroidx/compose/animation/core/AnimationSpec;Landroidx/compose/animation/core/AnimationSpec;)V", "vectorize", "Landroidx/compose/animation/core/VectorizedAnimationSpec;", "V", "Landroidx/compose/animation/core/AnimationVector;", "converter", "Landroidx/compose/animation/core/TwoWayConverter;", "foundation"})
final class DelegatingAnimationSpec
implements AnimationSpec<AnimationData> {
    @NotNull
    private final AnimationSpec<Float> zoomAnimationSpec;
    @NotNull
    private final AnimationSpec<Offset> offsetAnimationSpec;
    @NotNull
    private final AnimationSpec<Float> rotationAnimationSpec;

    public DelegatingAnimationSpec(@NotNull AnimationSpec<Float> zoomAnimationSpec, @NotNull AnimationSpec<Offset> offsetAnimationSpec, @NotNull AnimationSpec<Float> rotationAnimationSpec) {
        Intrinsics.checkNotNullParameter(zoomAnimationSpec, (String)"zoomAnimationSpec");
        Intrinsics.checkNotNullParameter(offsetAnimationSpec, (String)"offsetAnimationSpec");
        Intrinsics.checkNotNullParameter(rotationAnimationSpec, (String)"rotationAnimationSpec");
        this.zoomAnimationSpec = zoomAnimationSpec;
        this.offsetAnimationSpec = offsetAnimationSpec;
        this.rotationAnimationSpec = rotationAnimationSpec;
    }

    @Override
    @NotNull
    public <V extends AnimationVector> VectorizedAnimationSpec<V> vectorize(@NotNull TwoWayConverter<AnimationData, V> converter) {
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        VectorizedAnimationSpec<AnimationVector1D> vectorizedZoomAnimationSpec = this.zoomAnimationSpec.vectorize(VectorConvertersKt.getVectorConverter(FloatCompanionObject.INSTANCE));
        VectorizedAnimationSpec<AnimationVector2D> vectorizedOffsetAnimationSpec = this.offsetAnimationSpec.vectorize(VectorConvertersKt.getVectorConverter(Offset.Companion));
        VectorizedAnimationSpec<AnimationVector1D> vectorizedRotationAnimationSpec = this.rotationAnimationSpec.vectorize(VectorConvertersKt.getVectorConverter(FloatCompanionObject.INSTANCE));
        return new VectorizedFiniteAnimationSpec<V>(converter, vectorizedZoomAnimationSpec, vectorizedOffsetAnimationSpec, vectorizedRotationAnimationSpec){
            final /* synthetic */ TwoWayConverter<AnimationData, V> $converter;
            final /* synthetic */ VectorizedAnimationSpec<AnimationVector1D> $vectorizedZoomAnimationSpec;
            final /* synthetic */ VectorizedAnimationSpec<AnimationVector2D> $vectorizedOffsetAnimationSpec;
            final /* synthetic */ VectorizedAnimationSpec<AnimationVector1D> $vectorizedRotationAnimationSpec;
            {
                this.$converter = $converter;
                this.$vectorizedZoomAnimationSpec = $vectorizedZoomAnimationSpec;
                this.$vectorizedOffsetAnimationSpec = $vectorizedOffsetAnimationSpec;
                this.$vectorizedRotationAnimationSpec = $vectorizedRotationAnimationSpec;
            }

            public long getDurationNanos(V initialValue, V targetValue2, V initialVelocity) {
                Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
                Intrinsics.checkNotNullParameter(targetValue2, (String)"targetValue");
                Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
                AnimationData initialAnimationData = (AnimationData)this.$converter.getConvertFromVector().invoke(initialValue);
                AnimationData targetAnimationData = (AnimationData)this.$converter.getConvertFromVector().invoke(targetValue2);
                AnimationData initialVelocityAnimationData = (AnimationData)this.$converter.getConvertFromVector().invoke(initialVelocity);
                return Math.max(this.$vectorizedZoomAnimationSpec.getDurationNanos((AnimationVector1D)((AnimationVector)this.zoomVector(initialAnimationData)), (AnimationVector1D)((AnimationVector)this.zoomVector(targetAnimationData)), (AnimationVector1D)((AnimationVector)this.zoomVector(initialVelocityAnimationData))), Math.max(this.$vectorizedOffsetAnimationSpec.getDurationNanos((AnimationVector2D)((AnimationVector)this.offsetVector(initialAnimationData)), (AnimationVector2D)((AnimationVector)this.offsetVector(targetAnimationData)), (AnimationVector2D)((AnimationVector)this.offsetVector(initialVelocityAnimationData))), this.$vectorizedRotationAnimationSpec.getDurationNanos((AnimationVector1D)((AnimationVector)this.degreesVector(initialAnimationData)), (AnimationVector1D)((AnimationVector)this.degreesVector(targetAnimationData)), (AnimationVector1D)((AnimationVector)this.degreesVector(initialVelocityAnimationData)))));
            }

            public V getVelocityFromNanos(long playTimeNanos, V initialValue, V targetValue2, V initialVelocity) {
                Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
                Intrinsics.checkNotNullParameter(targetValue2, (String)"targetValue");
                Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
                AnimationData initialAnimationData = (AnimationData)this.$converter.getConvertFromVector().invoke(initialValue);
                AnimationData targetAnimationData = (AnimationData)this.$converter.getConvertFromVector().invoke(targetValue2);
                AnimationData initialVelocityAnimationData = (AnimationData)this.$converter.getConvertFromVector().invoke(initialVelocity);
                AnimationVector1D zoomVelocity = this.$vectorizedZoomAnimationSpec.getVelocityFromNanos(playTimeNanos, (AnimationVector1D)((AnimationVector)this.zoomVector(initialAnimationData)), (AnimationVector1D)((AnimationVector)this.zoomVector(targetAnimationData)), (AnimationVector1D)((AnimationVector)this.zoomVector(initialVelocityAnimationData)));
                AnimationVector2D offsetVelocity = this.$vectorizedOffsetAnimationSpec.getVelocityFromNanos(playTimeNanos, (AnimationVector2D)((AnimationVector)this.offsetVector(initialAnimationData)), (AnimationVector2D)((AnimationVector)this.offsetVector(targetAnimationData)), (AnimationVector2D)((AnimationVector)this.offsetVector(initialVelocityAnimationData)));
                AnimationVector1D rotationVelocity = this.$vectorizedRotationAnimationSpec.getVelocityFromNanos(playTimeNanos, (AnimationVector1D)((AnimationVector)this.degreesVector(initialAnimationData)), (AnimationVector1D)((AnimationVector)this.degreesVector(targetAnimationData)), (AnimationVector1D)((AnimationVector)this.degreesVector(initialVelocityAnimationData)));
                return this.packToAnimationVector(zoomVelocity, offsetVelocity, rotationVelocity);
            }

            public V getValueFromNanos(long playTimeNanos, V initialValue, V targetValue2, V initialVelocity) {
                Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
                Intrinsics.checkNotNullParameter(targetValue2, (String)"targetValue");
                Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
                AnimationData initialAnimationData = (AnimationData)this.$converter.getConvertFromVector().invoke(initialValue);
                AnimationData targetAnimationData = (AnimationData)this.$converter.getConvertFromVector().invoke(targetValue2);
                AnimationData initialVelocityAnimationData = (AnimationData)this.$converter.getConvertFromVector().invoke(initialVelocity);
                AnimationVector1D zoomValue = this.$vectorizedZoomAnimationSpec.getValueFromNanos(playTimeNanos, (AnimationVector1D)((AnimationVector)this.zoomVector(initialAnimationData)), (AnimationVector1D)((AnimationVector)this.zoomVector(targetAnimationData)), (AnimationVector1D)((AnimationVector)this.zoomVector(initialVelocityAnimationData)));
                AnimationVector2D offsetValue = this.$vectorizedOffsetAnimationSpec.getValueFromNanos(playTimeNanos, (AnimationVector2D)((AnimationVector)this.offsetVector(initialAnimationData)), (AnimationVector2D)((AnimationVector)this.offsetVector(targetAnimationData)), (AnimationVector2D)((AnimationVector)this.offsetVector(initialVelocityAnimationData)));
                AnimationVector1D rotationValue = this.$vectorizedRotationAnimationSpec.getValueFromNanos(playTimeNanos, (AnimationVector1D)((AnimationVector)this.degreesVector(initialAnimationData)), (AnimationVector1D)((AnimationVector)this.degreesVector(targetAnimationData)), (AnimationVector1D)((AnimationVector)this.degreesVector(initialVelocityAnimationData)));
                return this.packToAnimationVector(zoomValue, offsetValue, rotationValue);
            }

            private final AnimationVector1D zoomVector(AnimationData $this$zoomVector) {
                return (AnimationVector1D)VectorConvertersKt.getVectorConverter(FloatCompanionObject.INSTANCE).getConvertToVector().invoke((Object)Float.valueOf($this$zoomVector.getZoom()));
            }

            /*
             * WARNING - void declaration
             */
            private final AnimationVector2D offsetVector(AnimationData $this$offsetVector) {
                void val1$iv$iv;
                void x$iv;
                long $v$c$androidx-compose-ui-geometry-Offset$-this$0$iv22 = $this$offsetVector.getOffset-F1C5BW0();
                boolean bl = false;
                long value$iv$iv = $v$c$androidx-compose-ui-geometry-Offset$-this$0$iv22;
                boolean $i$f$unpackFloat1 = false;
                int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
                boolean $i$f$floatFromBits = false;
                float $v$c$androidx-compose-ui-geometry-Offset$-this$0$iv22 = Float.intBitsToFloat(bits$iv$iv$iv);
                long l = $this$offsetVector.getOffset-F1C5BW0();
                boolean $i$f$getY-impl22 = false;
                long value$iv$iv2 = l;
                boolean $i$f$unpackFloat2 = false;
                int bits$iv$iv$iv2 = (int)(value$iv$iv2 & 0xFFFFFFFFL);
                boolean $i$f$floatFromBits2 = false;
                float y$iv = Float.intBitsToFloat(bits$iv$iv$iv2);
                boolean $i$f$Offset = false;
                void $i$f$getY-impl22 = x$iv;
                float val2$iv$iv = y$iv;
                boolean $i$f$packFloats = false;
                long v1$iv$iv = Float.floatToRawIntBits((float)val1$iv$iv);
                long v2$iv$iv = Float.floatToRawIntBits(val2$iv$iv);
                return (AnimationVector2D)VectorConvertersKt.getVectorConverter(Offset.Companion).getConvertToVector().invoke((Object)Offset.box-impl(Offset.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL)));
            }

            private final AnimationVector1D degreesVector(AnimationData $this$degreesVector) {
                return (AnimationVector1D)VectorConvertersKt.getVectorConverter(FloatCompanionObject.INSTANCE).getConvertToVector().invoke((Object)Float.valueOf($this$degreesVector.getDegrees()));
            }

            /*
             * WARNING - void declaration
             */
            private final V packToAnimationVector(AnimationVector1D zoom, AnimationVector2D offset, AnimationVector1D rotation) {
                void val1$iv$iv;
                void x$iv;
                float f = offset.getV1();
                float y$iv = offset.getV2();
                boolean $i$f$Offset = false;
                void var7_7 = x$iv;
                float val2$iv$iv = y$iv;
                boolean $i$f$packFloats = false;
                long v1$iv$iv = Float.floatToRawIntBits((float)val1$iv$iv);
                long v2$iv$iv = Float.floatToRawIntBits(val2$iv$iv);
                return (V)((AnimationVector)this.$converter.getConvertToVector().invoke((Object)new AnimationData(zoom.getValue(), Offset.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL), rotation.getValue(), null)));
            }
        };
    }
}

