/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.connection;

import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.socketConnection.ConnectionState;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.Vm;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u0010J\f\u0010 \u001a\u0006\u0012\u0002\b\u00030)H\u0007J)\u0010*\u001a\u00020\u00162!\u0010+\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b,\u0012\b\b-\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u00160\u0015J(\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u0002002\n\b\u0002\u00101\u001a\u0004\u0018\u0001022\n\b\u0002\u00103\u001a\u0004\u0018\u000104H\u0004J\u001a\u00105\u001a\u00020\u00162\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00160\u0015J\b\u00109\u001a\u00020\u0016H\u0014J\u0018\u0010:\u001a\u00020\u00162\b\u00101\u001a\u0004\u0018\u0001022\u0006\u0010/\u001a\u000200J\b\u0010;\u001a\u00020<H\u0016J\b\u0010=\u001a\u00020\u0016H\u0016J\f\u0010>\u001a\u0006\u0012\u0002\b\u00030)H\u0016R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012Rj\u0010\u0013\u001a^\u0012$\u0012\"\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0016 \r*\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00150\u0015 \r*-\u0012$\u0012\"\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0016 \r*\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00150\u00150\u0018\u00a2\u0006\u0002\b\u00170\u0014\u00a2\u0006\u0002\b\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u001a\u001a\u0004\u0018\u00018\u00002\b\u0010\u0019\u001a\u0004\u0018\u00018\u0000@DX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010$\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u00106\u001a\u00020\u00108DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108\u00a8\u0006?"}, d2={"Lorg/jetbrains/debugger/connection/VmConnection;", "T", "Lorg/jetbrains/debugger/Vm;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "getBrowser", "()Lcom/intellij/ide/browsers/WebBrowser;", "stateRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/util/io/socketConnection/ConnectionState;", "kotlin.jvm.PlatformType", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "Lorg/jetbrains/debugger/DebugEventListener;", "getDispatcher", "()Lcom/intellij/util/EventDispatcher;", "connectionDispatcher", "", "Lkotlin/Function1;", "", "Lorg/jetbrains/annotations/NotNull;", "", "value", "vm", "getVm", "()Lorg/jetbrains/debugger/Vm;", "setVm", "(Lorg/jetbrains/debugger/Vm;)V", "Lorg/jetbrains/debugger/Vm;", "opened", "Lorg/jetbrains/concurrency/AsyncPromise;", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "state", "getState", "()Lcom/intellij/util/io/socketConnection/ConnectionState;", "addDebugListener", "listener", "Lorg/jetbrains/concurrency/Promise;", "executeOnStart", "consumer", "Lkotlin/ParameterName;", "name", "setState", "status", "Lcom/intellij/util/io/socketConnection/ConnectionStatus;", "message", "", "messageLinkListener", "Ljavax/swing/event/HyperlinkListener;", "stateChanged", "debugEventListener", "getDebugEventListener", "()Lorg/jetbrains/debugger/DebugEventListener;", "startProcessing", "close", "shouldDisposeOnClose", "", "dispose", "detachAndClose", "intellij.platform.scriptDebugger.ui"})
@SourceDebugExtension(value={"SMAP\nVmConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VmConnection.kt\norg/jetbrains/debugger/connection/VmConnection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
public abstract class VmConnection<T extends Vm>
implements Disposable {
    @Nullable
    private final WebBrowser browser;
    @NotNull
    private final AtomicReference<ConnectionState> stateRef = new AtomicReference<ConnectionState>(new ConnectionState(ConnectionStatus.NOT_CONNECTED));
    @NotNull
    private final EventDispatcher<DebugEventListener> dispatcher;
    @NotNull
    private final List<Function1<ConnectionState, Unit>> connectionDispatcher;
    @Nullable
    private volatile T vm;
    @NotNull
    private final AsyncPromise<T> opened;
    @NotNull
    private final AtomicBoolean closed;

    public VmConnection() {
        EventDispatcher eventDispatcher = EventDispatcher.create(DebugEventListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.dispatcher = eventDispatcher;
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createLockFreeCopyOnWriteList(...)");
        this.connectionDispatcher = list;
        this.opened = new AsyncPromise();
        this.closed = new AtomicBoolean();
    }

    @Nullable
    public WebBrowser getBrowser() {
        return this.browser;
    }

    @NotNull
    protected EventDispatcher<DebugEventListener> getDispatcher() {
        return this.dispatcher;
    }

    @Nullable
    public final T getVm() {
        return this.vm;
    }

    protected final void setVm(@Nullable T t) {
        this.vm = t;
    }

    @NotNull
    public final ConnectionState getState() {
        ConnectionState connectionState = this.stateRef.get();
        Intrinsics.checkNotNullExpressionValue((Object)connectionState, (String)"get(...)");
        return connectionState;
    }

    public final void addDebugListener(@NotNull DebugEventListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.getDispatcher().addListener((EventListener)listener);
    }

    @TestOnly
    @NotNull
    public final Promise<?> opened() {
        return (Promise)this.opened;
    }

    public final void executeOnStart(@NotNull Function1<? super T, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.opened.then(arg_0 -> VmConnection.executeOnStart$lambda$0(consumer, arg_0));
    }

    protected final void setState(@NotNull ConnectionStatus status, @Nullable String message, @Nullable HyperlinkListener messageLinkListener) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        ConnectionState newState = new ConnectionState(status, message, messageLinkListener);
        ConnectionState oldState = this.stateRef.getAndSet(newState);
        if (oldState == null || oldState.getStatus() != status) {
            if (status == ConnectionStatus.CONNECTION_FAILED) {
                String string = newState.getMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
                this.opened.setError(string);
            }
            for (Function1<ConnectionState, Unit> listener : this.connectionDispatcher) {
                listener.invoke((Object)newState);
            }
        }
    }

    public static /* synthetic */ void setState$default(VmConnection vmConnection, ConnectionStatus connectionStatus, String string, HyperlinkListener hyperlinkListener, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setState");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            hyperlinkListener = null;
        }
        vmConnection.setState(connectionStatus, string, hyperlinkListener);
    }

    public final void stateChanged(@NotNull Function1<? super ConnectionState, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.connectionDispatcher.add(listener);
    }

    @NotNull
    protected final DebugEventListener getDebugEventListener() {
        EventListener eventListener = this.getDispatcher().getMulticaster();
        Intrinsics.checkNotNullExpressionValue((Object)eventListener, (String)"getMulticaster(...)");
        return (DebugEventListener)eventListener;
    }

    protected void startProcessing() {
        block0: {
            T t = this.vm;
            if (t == null) break block0;
            T it = t;
            boolean bl = false;
            this.opened.setResult(it);
        }
    }

    public final void close(@Nullable String message, @NotNull ConnectionStatus status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        if (Promises.isPending((Promise)((Promise)this.opened))) {
            this.opened.setError("closed");
        }
        VmConnection.setState$default(this, status, message, null, 4, null);
        if (this.shouldDisposeOnClose()) {
            Disposer.dispose((Disposable)this, (boolean)false);
        }
    }

    public boolean shouldDisposeOnClose() {
        return true;
    }

    public void dispose() {
        this.vm = null;
    }

    @NotNull
    public Promise<?> detachAndClose() {
        if (Promises.isPending((Promise)((Promise)this.opened))) {
            this.opened.setError((Throwable)Promises.createError$default((String)"detached and closed", (boolean)false, (int)2, null));
        }
        T currentVm = this.vm;
        Promise callback = null;
        if (currentVm == null) {
            callback = Promises.nullPromise();
        } else {
            this.vm = null;
            callback = currentVm.getAttachStateManager().detach();
        }
        this.close(null, ConnectionStatus.DISCONNECTED);
        return callback;
    }

    private static final Unit executeOnStart$lambda$0(Function1 $tmp0, Object p0) {
        return (Unit)$tmp0.invoke(p0);
    }
}

