/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.impl;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeInspectionBase;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.meta.model.YamlScalarType;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLSequenceItem;

@ApiStatus.Internal
public abstract class YamlMissingKeysInspectionBase
extends YamlMetaTypeInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor doBuildVisitor(@NotNull ProblemsHolder holder, @NotNull YamlMetaTypeProvider metaTypeProvider) {
        if (holder == null) {
            YamlMissingKeysInspectionBase.$$$reportNull$$$0(0);
        }
        if (metaTypeProvider == null) {
            YamlMissingKeysInspectionBase.$$$reportNull$$$0(1);
        }
        return new StructureChecker(holder, metaTypeProvider);
    }

    @Nullable
    private static PsiElement getMappingFromHighlightElement(PsiElement elementToHighlight) {
        if (elementToHighlight instanceof YAMLDocument) {
            return PsiTreeUtil.getChildOfAnyType((PsiElement)elementToHighlight, (Class[])new Class[]{YAMLMapping.class});
        }
        PsiElement parent = elementToHighlight.getParent();
        if (parent instanceof YAMLKeyValue) {
            return ((YAMLKeyValue)parent).getValue();
        }
        if (parent instanceof YAMLSequenceItem) {
            return ((YAMLSequenceItem)parent).getValue();
        }
        return PsiTreeUtil.getParentOfType((PsiElement)elementToHighlight, YAMLMapping.class);
    }

    @NotNull
    protected PsiElement getElementToHighlight(@NotNull YAMLMapping mapping) {
        PsiElement parent;
        if (mapping == null) {
            YamlMissingKeysInspectionBase.$$$reportNull$$$0(2);
        }
        if ((parent = mapping.getParent()) instanceof YAMLDocument) {
            PsiElement psiElement = parent;
            if (psiElement == null) {
                YamlMissingKeysInspectionBase.$$$reportNull$$$0(3);
            }
            return psiElement;
        }
        if (parent instanceof YAMLSequenceItem) {
            PsiElement key = parent.getFirstChild();
            Object object = key != null ? key : mapping;
            if (object == null) {
                YamlMissingKeysInspectionBase.$$$reportNull$$$0(4);
            }
            return object;
        }
        if (parent instanceof YAMLKeyValue) {
            PsiElement key = ((YAMLKeyValue)parent).getKey();
            Object object = key != null ? key : mapping;
            if (object == null) {
                YamlMissingKeysInspectionBase.$$$reportNull$$$0(5);
            }
            return object;
        }
        YAMLMapping yAMLMapping = mapping;
        if (yAMLMapping == null) {
            YamlMissingKeysInspectionBase.$$$reportNull$$$0(6);
        }
        return yAMLMapping;
    }

    @NotNull
    private static String composeKeyList(@NotNull Collection<String> missingKeys) {
        if (missingKeys == null) {
            YamlMissingKeysInspectionBase.$$$reportNull$$$0(7);
        }
        String string = String.join((CharSequence)", ", missingKeys);
        if (string == null) {
            YamlMissingKeysInspectionBase.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static Collection<String> getMissingKeys(@NotNull YAMLMapping mapping, @NotNull YamlMetaType metaClass) {
        if (mapping == null) {
            YamlMissingKeysInspectionBase.$$$reportNull$$$0(9);
        }
        if (metaClass == null) {
            YamlMissingKeysInspectionBase.$$$reportNull$$$0(10);
        }
        Set<String> existingKeys = mapping.getKeyValues().stream().map(it -> it.getKeyText().trim()).collect(Collectors.toSet());
        List<String> list = metaClass.computeMissingFields(existingKeys);
        if (list == null) {
            YamlMissingKeysInspectionBase.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 8, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaTypeProvider";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/meta/impl/YamlMissingKeysInspectionBase";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "missingKeys";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/meta/impl/YamlMissingKeysInspectionBase";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementToHighlight";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "composeKeyList";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMissingKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doBuildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElementToHighlight";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "composeKeyList";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getMissingKeys";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 8, 11 -> new IllegalStateException(string);
        };
    }

    protected class StructureChecker
    extends YamlMetaTypeInspectionBase.SimpleYamlPsiVisitor {
        private final YamlMetaTypeProvider myMetaTypeProvider;
        private final ProblemsHolder myProblemsHolder;

        public StructureChecker(@NotNull ProblemsHolder problemsHolder, YamlMetaTypeProvider metaTypeProvider) {
            if (problemsHolder == null) {
                StructureChecker.$$$reportNull$$$0(0);
            }
            if (metaTypeProvider == null) {
                StructureChecker.$$$reportNull$$$0(1);
            }
            this.myProblemsHolder = problemsHolder;
            this.myMetaTypeProvider = metaTypeProvider;
        }

        @Override
        protected void visitYAMLMapping(@NotNull YAMLMapping mapping) {
            YamlMetaTypeProvider.MetaTypeProxy meta;
            if (mapping == null) {
                StructureChecker.$$$reportNull$$$0(2);
            }
            if ((meta = this.myMetaTypeProvider.getMetaTypeProxy((PsiElement)mapping)) == null) {
                return;
            }
            YamlMetaType metaType = meta.getMetaType();
            if (metaType instanceof YamlScalarType) {
                return;
            }
            Collection<String> missingKeys = YamlMissingKeysInspectionBase.getMissingKeys(mapping, metaType);
            if (!missingKeys.isEmpty()) {
                String msg = YAMLBundle.message((String)"YamlMissingKeysInspectionBase.missing.keys", (Object[])new Object[]{YamlMissingKeysInspectionBase.composeKeyList(missingKeys)});
                PsiElement element = YamlMissingKeysInspectionBase.this.getElementToHighlight(mapping);
                List<LocalQuickFix> quickFixes = this.getQuickFixes(missingKeys, element);
                this.myProblemsHolder.registerProblem(element, msg, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }

        @NotNull
        protected List<LocalQuickFix> getQuickFixes(@NotNull Collection<String> missingKeys, @NotNull PsiElement element) {
            if (missingKeys == null) {
                StructureChecker.$$$reportNull$$$0(3);
            }
            if (element == null) {
                StructureChecker.$$$reportNull$$$0(4);
            }
            List<AddMissingKeysQuickFix> list = List.of(new AddMissingKeysQuickFix(missingKeys, element));
            if (list == null) {
                StructureChecker.$$$reportNull$$$0(5);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problemsHolder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "metaTypeProvider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapping";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "missingKeys";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/yaml/meta/impl/YamlMissingKeysInspectionBase$StructureChecker";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/yaml/meta/impl/YamlMissingKeysInspectionBase$StructureChecker";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQuickFixes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitYAMLMapping";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getQuickFixes";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }

    private static class AddMissingKeysQuickFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        @FileModifier.SafeFieldForPreview
        private final Collection<String> myMissingKeys;

        AddMissingKeysQuickFix(@NotNull Collection<String> missingKeys, @NotNull PsiElement psiElement) {
            if (missingKeys == null) {
                AddMissingKeysQuickFix.$$$reportNull$$$0(0);
            }
            if (psiElement == null) {
                AddMissingKeysQuickFix.$$$reportNull$$$0(1);
            }
            super(psiElement);
            this.myMissingKeys = missingKeys;
        }

        @Nls
        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                AddMissingKeysQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = YAMLBundle.message((String)"YamlMissingKeysInspectionBase.add.missing.keys.quickfix.name", (Object[])new Object[0]);
            if (string == null) {
                AddMissingKeysQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            PsiElement mapping;
            if (project == null) {
                AddMissingKeysQuickFix.$$$reportNull$$$0(4);
            }
            if (psiFile == null) {
                AddMissingKeysQuickFix.$$$reportNull$$$0(5);
            }
            if (startElement == null) {
                AddMissingKeysQuickFix.$$$reportNull$$$0(6);
            }
            if (endElement == null) {
                AddMissingKeysQuickFix.$$$reportNull$$$0(7);
            }
            return (mapping = YamlMissingKeysInspectionBase.getMappingFromHighlightElement(startElement)) != null;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            PsiElement mapping;
            if (project == null) {
                AddMissingKeysQuickFix.$$$reportNull$$$0(8);
            }
            if (psiFile == null) {
                AddMissingKeysQuickFix.$$$reportNull$$$0(9);
            }
            if (startElement == null) {
                AddMissingKeysQuickFix.$$$reportNull$$$0(10);
            }
            if (endElement == null) {
                AddMissingKeysQuickFix.$$$reportNull$$$0(11);
            }
            if ((mapping = YamlMissingKeysInspectionBase.getMappingFromHighlightElement(startElement)) == null) {
                return;
            }
            YAMLElementGenerator elementGenerator = YAMLElementGenerator.getInstance((Project)project);
            int indent = YAMLUtil.getIndentToThisElement((PsiElement)mapping);
            PsiElement firstInsertedKey = null;
            for (String missingKey : this.myMissingKeys) {
                mapping.add(elementGenerator.createEol());
                mapping.add(elementGenerator.createIndent(indent));
                PsiElement newElement = mapping.add((PsiElement)elementGenerator.createYamlKeyValue(missingKey, ""));
                if (firstInsertedKey != null) continue;
                firstInsertedKey = newElement;
            }
            if (editor != null && firstInsertedKey != null) {
                editor.getCaretModel().moveToOffset(firstInsertedKey.getTextOffset() + firstInsertedKey.getTextLength());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "missingKeys";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/yaml/meta/impl/YamlMissingKeysInspectionBase$AddMissingKeysQuickFix";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/yaml/meta/impl/YamlMissingKeysInspectionBase$AddMissingKeysQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

