/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NameGenerator {
    private final String generatorClass;
    private int nextLambdaIndex = 1;
    private int nextWhenIndex = 1;
    private final Map<String, NameGenerator> subGenerators = new HashMap<String, NameGenerator>();

    public NameGenerator(String generatorClass) {
        this.generatorClass = generatorClass;
    }

    public String getGeneratorClass() {
        return this.generatorClass;
    }

    private String genLambdaClassName() {
        return this.generatorClass + "$" + this.nextLambdaIndex++;
    }

    private String genWhenClassName(@NotNull String original) {
        if (original == null) {
            NameGenerator.$$$reportNull$$$0(0);
        }
        return this.generatorClass + "$" + this.nextWhenIndex++ + "$wm$" + original;
    }

    public NameGenerator subGenerator(String inliningMethod) {
        return this.subGenerators.computeIfAbsent(inliningMethod, method -> new NameGenerator(this.generatorClass + "$" + method));
    }

    @NotNull
    public NameGenerator subGenerator(boolean lambdaNoWhen, @Nullable String nameSuffix) {
        String generatorClass;
        String string = generatorClass = lambdaNoWhen ? this.genLambdaClassName() : this.genWhenClassName(nameSuffix);
        assert (!this.subGenerators.containsKey(generatorClass)) : "Name generator for regenerated class should be unique: " + generatorClass;
        NameGenerator generator = new NameGenerator(generatorClass);
        this.subGenerators.put(generatorClass, generator);
        NameGenerator nameGenerator2 = generator;
        if (nameGenerator2 == null) {
            NameGenerator.$$$reportNull$$$0(1);
        }
        return nameGenerator2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/inline/NameGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/inline/NameGenerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "subGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "genWhenClassName";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

