
#ifndef KDAV_EXPORT_H
#define KDAV_EXPORT_H

#ifdef KDAV_STATIC_DEFINE
#  define KDAV_EXPORT
#  define KDAV_NO_EXPORT
#else
#  ifndef KDAV_EXPORT
#    ifdef KF6DAV_EXPORTS
        /* We are building this library */
#      define KDAV_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KDAV_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KDAV_NO_EXPORT
#    define KDAV_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KDAV_DECL_DEPRECATED
#  define KDAV_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KDAV_DECL_DEPRECATED_EXPORT
#  define KDAV_DECL_DEPRECATED_EXPORT KDAV_EXPORT KDAV_DECL_DEPRECATED
#endif

#ifndef KDAV_DECL_DEPRECATED_NO_EXPORT
#  define KDAV_DECL_DEPRECATED_NO_EXPORT KDAV_NO_EXPORT KDAV_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KDAV_NO_DEPRECATED
#    define KDAV_NO_DEPRECATED
#  endif
#endif
#include <kdav_version.h>

#define KDAV_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(KDAV_NO_DEPRECATED) && !defined(KDAV_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KDAV_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KDAV_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KDAV_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KDAV_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KDAV_NO_DEPRECATED_WARNINGS) && !defined(KDAV_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KDAV_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KDAV_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KDAV_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KDAV_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KDAV_NO_DEPRECATED)
#  undef KDAV_DEPRECATED
#  define KDAV_DEPRECATED_EXPORT KDAV_EXPORT
#  define KDAV_DEPRECATED_NO_EXPORT KDAV_NO_EXPORT
#elif defined(KDAV_NO_DEPRECATED_WARNINGS)
#  define KDAV_DEPRECATED
#  define KDAV_DEPRECATED_EXPORT KDAV_EXPORT
#  define KDAV_DEPRECATED_NO_EXPORT KDAV_NO_EXPORT
#else
#  define KDAV_DEPRECATED KDAV_DECL_DEPRECATED
#  define KDAV_DEPRECATED_EXPORT KDAV_DECL_DEPRECATED_EXPORT
#  define KDAV_DEPRECATED_NO_EXPORT KDAV_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KDAV_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KDAV_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KDAV_NO_DEPRECATED
#  define KDAV_DISABLE_DEPRECATED_BEFORE_AND_AT KDAV_VERSION
#endif
#ifdef KDAV_NO_DEPRECATED_WARNINGS
#  define KDAV_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KDAV_DEPRECATED_WARNINGS_SINCE
#  ifdef KDAV_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KDAV_DEPRECATED_WARNINGS_SINCE KDAV_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KDAV_DEPRECATED_WARNINGS_SINCE KDAV_VERSION
#  endif
#endif

#ifndef KDAV_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KDAV_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KDAV_DEPRECATED
#  define KDAV_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KDAV_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KDAV_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* KDAV_EXPORT_H */
