/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.GenerationType;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Timeout;
import java.lang.reflect.Type;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.QueryTimeoutException;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.CockroachDialectQueryHints;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupportImpl;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.NullOrdering;
import org.hibernate.dialect.PostgreSQLDriverKind;
import org.hibernate.dialect.SimpleDatabaseVersion;
import org.hibernate.dialect.SpannerDialect;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.CockroachDBAggregateSupport;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.FormatFunction;
import org.hibernate.dialect.function.PostgreSQLTruncFunction;
import org.hibernate.dialect.identity.CockroachDBIdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.lock.internal.CockroachLockingSupport;
import org.hibernate.dialect.lock.spi.LockingSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.OffsetFetchLimitHandler;
import org.hibernate.dialect.sequence.PostgreSQLSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.sql.ast.CockroachSqlAstTranslator;
import org.hibernate.dialect.type.PgJdbcHelper;
import org.hibernate.dialect.type.PostgreSQLArrayJdbcTypeConstructor;
import org.hibernate.dialect.type.PostgreSQLCastingInetJdbcType;
import org.hibernate.dialect.type.PostgreSQLCastingIntervalSecondJdbcType;
import org.hibernate.dialect.type.PostgreSQLCastingJsonArrayJdbcTypeConstructor;
import org.hibernate.dialect.type.PostgreSQLCastingJsonJdbcType;
import org.hibernate.dialect.type.PostgreSQLEnumJdbcType;
import org.hibernate.dialect.type.PostgreSQLOrdinalEnumJdbcType;
import org.hibernate.dialect.type.PostgreSQLUUIDJdbcType;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierCaseStrategy;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.TransactionSerializationException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.query.SemanticException;
import org.hibernate.query.common.TemporalUnit;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.jdbc.BlobJdbcType;
import org.hibernate.type.descriptor.jdbc.ClobJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.NClobJdbcType;
import org.hibernate.type.descriptor.jdbc.ObjectNullAsBinaryTypeJdbcType;
import org.hibernate.type.descriptor.jdbc.UUIDJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.NamedNativeEnumDdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.NamedNativeOrdinalEnumDdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.Scale6IntervalSecondDdlType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class CockroachDialect
extends Dialect {
    private static final Pattern CRDB_VERSION_PATTERN = Pattern.compile("v[\\d]+(\\.[\\d]+)?(\\.[\\d]+)?");
    protected static final DatabaseVersion MINIMUM_VERSION = DatabaseVersion.make(23, 1);
    protected final PostgreSQLDriverKind driverKind;
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        String string;
        String sqlState = JdbcExceptionHelper.extractSqlState(sqle);
        if (sqlState == null) {
            string = null;
        } else {
            switch (Integer.parseInt(sqlState)) {
                case 23503: 
                case 23505: 
                case 23514: {
                    string = TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("constraint \"", "\"", sqle.getMessage());
                    break;
                }
                case 23502: {
                    string = TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("column \"", "\"", sqle.getMessage());
                    break;
                }
                default: {
                    string = null;
                }
            }
        }
        return string;
    });

    public CockroachDialect() {
        this(MINIMUM_VERSION);
    }

    public CockroachDialect(DialectResolutionInfo info) {
        this(CockroachDialect.fetchDataBaseVersion(info), PostgreSQLDriverKind.determineKind(info));
        this.registerKeywords(info);
    }

    public CockroachDialect(DialectResolutionInfo info, String versionString) {
        this(versionString == null ? info.makeCopyOrDefault(MINIMUM_VERSION) : CockroachDialect.parseVersion(versionString), PostgreSQLDriverKind.determineKind(info));
        this.registerKeywords(info);
    }

    public CockroachDialect(DatabaseVersion version) {
        super(version);
        this.driverKind = PostgreSQLDriverKind.PG_JDBC;
    }

    public CockroachDialect(DatabaseVersion version, PostgreSQLDriverKind driverKind) {
        super(version);
        this.driverKind = driverKind;
    }

    @Override
    public DatabaseVersion determineDatabaseVersion(DialectResolutionInfo info) {
        return CockroachDialect.fetchDataBaseVersion(info);
    }

    protected static DatabaseVersion fetchDataBaseVersion(DialectResolutionInfo info) {
        String versionString = null;
        DatabaseMetaData databaseMetadata = info.getDatabaseMetadata();
        if (databaseMetadata != null) {
            try (Statement statement = databaseMetadata.getConnection().createStatement();){
                ResultSet resultSet = statement.executeQuery("SELECT version()");
                if (resultSet.next()) {
                    versionString = resultSet.getString(1);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (versionString == null) {
            versionString = ConfigurationHelper.getString("hibernate.dialect.cockroach.version_string", info.getConfigurationValues());
        }
        return versionString != null ? CockroachDialect.parseVersion(versionString) : info.makeCopyOrDefault(MINIMUM_VERSION);
    }

    public static DatabaseVersion parseVersion(String versionString) {
        DatabaseVersion databaseVersion = null;
        Matcher matcher = CRDB_VERSION_PATTERN.matcher(versionString == null ? "" : versionString);
        if (matcher.find()) {
            String[] versionParts = StringHelper.split(".", matcher.group().substring(1));
            int majorVersion = Integer.parseInt(versionParts[0]);
            int minorVersion = versionParts.length > 1 ? Integer.parseInt(versionParts[1]) : 0;
            int microVersion = versionParts.length > 2 ? Integer.parseInt(versionParts[2]) : 0;
            databaseVersion = new SimpleDatabaseVersion(majorVersion, minorVersion, microVersion);
        }
        if (databaseVersion == null) {
            databaseVersion = MINIMUM_VERSION;
        }
        return databaseVersion;
    }

    @Override
    protected DatabaseVersion getMinimumSupportedVersion() {
        return MINIMUM_VERSION;
    }

    @Override
    protected String columnType(int sqlTypeCode) {
        return switch (sqlTypeCode) {
            case -6 -> "smallint";
            case 4 -> "int4";
            case -15 -> this.columnType(1);
            case -9 -> this.columnType(12);
            case 2005, 2011 -> "string";
            case -3, -2, 2004 -> "bytes";
            case 3003 -> this.columnType(2014);
            default -> super.columnType(sqlTypeCode);
        };
    }

    @Override
    protected String castType(int sqlTypeCode) {
        return switch (sqlTypeCode) {
            case -15, -9, 1, 12, 4001, 4002 -> "string";
            case -3, -2, 4003 -> "bytes";
            default -> super.castType(sqlTypeCode);
        };
    }

    @Override
    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3000, "uuid", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3200, "geometry", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3250, "geography", this));
        ddlTypeRegistry.addDescriptor(new Scale6IntervalSecondDdlType(this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3002, "inet", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3001, "jsonb", this));
        ddlTypeRegistry.addDescriptor(new NamedNativeEnumDdlTypeImpl(this));
        ddlTypeRegistry.addDescriptor(new NamedNativeOrdinalEnumDdlTypeImpl(this));
    }

    @Override
    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        switch (jdbcTypeCode) {
            case 1111: {
                switch (columnTypeName) {
                    case "uuid": {
                        jdbcTypeCode = 3000;
                        break;
                    }
                    case "json": 
                    case "jsonb": {
                        jdbcTypeCode = 3001;
                        break;
                    }
                    case "inet": {
                        jdbcTypeCode = 3002;
                        break;
                    }
                    case "geometry": {
                        jdbcTypeCode = 3200;
                        break;
                    }
                    case "geography": {
                        jdbcTypeCode = 3250;
                    }
                }
                break;
            }
            case 92: {
                if (!"timetz".equals(columnTypeName)) break;
                jdbcTypeCode = 3007;
                break;
            }
            case 93: {
                if (!"timestamptz".equals(columnTypeName)) break;
                jdbcTypeCode = 3003;
                break;
            }
            case 2003: {
                String componentTypeName;
                Integer sqlTypeCode;
                if (columnTypeName.charAt(0) != '_' || (sqlTypeCode = this.resolveSqlTypeCode(componentTypeName = columnTypeName.substring(1), jdbcTypeRegistry.getTypeConfiguration())) == null) break;
                return jdbcTypeRegistry.resolveTypeConstructorDescriptor(jdbcTypeCode, jdbcTypeRegistry.getDescriptor(sqlTypeCode), ColumnTypeInformation.EMPTY);
            }
        }
        return jdbcTypeRegistry.getDescriptor(jdbcTypeCode);
    }

    @Override
    protected Integer resolveSqlTypeCode(String columnTypeName, TypeConfiguration typeConfiguration) {
        return switch (columnTypeName) {
            case "bool" -> 16;
            case "float4" -> 7;
            case "float8" -> 8;
            case "int2" -> 5;
            case "int4" -> 4;
            case "int8" -> -5;
            default -> super.resolveSqlTypeCode(columnTypeName, typeConfiguration);
        };
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        this.contributeCockroachTypes(typeContributions, serviceRegistry);
    }

    protected void contributeCockroachTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        if (this.driverKind == PostgreSQLDriverKind.PG_JDBC) {
            jdbcTypeRegistry.addDescriptor(PostgreSQLEnumJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptor(PostgreSQLOrdinalEnumJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptorIfAbsent(PostgreSQLUUIDJdbcType.INSTANCE);
            if (PgJdbcHelper.isUsable(serviceRegistry)) {
                jdbcTypeRegistry.addDescriptorIfAbsent(PgJdbcHelper.getIntervalJdbcType(serviceRegistry));
                jdbcTypeRegistry.addDescriptorIfAbsent(PgJdbcHelper.getInetJdbcType(serviceRegistry));
                jdbcTypeRegistry.addDescriptorIfAbsent(PgJdbcHelper.getJsonbJdbcType(serviceRegistry));
                jdbcTypeRegistry.addTypeConstructorIfAbsent(PgJdbcHelper.getJsonbArrayJdbcType(serviceRegistry));
            } else {
                jdbcTypeRegistry.addDescriptorIfAbsent(PostgreSQLCastingIntervalSecondJdbcType.INSTANCE);
                jdbcTypeRegistry.addDescriptorIfAbsent(PostgreSQLCastingInetJdbcType.INSTANCE);
                jdbcTypeRegistry.addDescriptorIfAbsent(PostgreSQLCastingJsonJdbcType.JSONB_INSTANCE);
                jdbcTypeRegistry.addTypeConstructorIfAbsent(PostgreSQLCastingJsonArrayJdbcTypeConstructor.JSONB_INSTANCE);
            }
        } else {
            jdbcTypeRegistry.addDescriptorIfAbsent(UUIDJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptorIfAbsent(PostgreSQLCastingInetJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptorIfAbsent(PostgreSQLCastingIntervalSecondJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptorIfAbsent(PostgreSQLCastingJsonJdbcType.JSONB_INSTANCE);
            jdbcTypeRegistry.addTypeConstructorIfAbsent(PostgreSQLCastingJsonArrayJdbcTypeConstructor.JSONB_INSTANCE);
        }
        jdbcTypeRegistry.addDescriptor(2004, BlobJdbcType.MATERIALIZED);
        jdbcTypeRegistry.addDescriptor(2005, ClobJdbcType.MATERIALIZED);
        jdbcTypeRegistry.addDescriptor(2011, NClobJdbcType.MATERIALIZED);
        typeContributions.contributeJdbcType(ObjectNullAsBinaryTypeJdbcType.INSTANCE);
        typeContributions.contributeType(new JavaObjectType((JdbcType)ObjectNullAsBinaryTypeJdbcType.INSTANCE, typeContributions.getTypeConfiguration().getJavaTypeRegistry().getDescriptor((Type)((Object)Object.class))));
        jdbcTypeRegistry.addTypeConstructor(PostgreSQLArrayJdbcTypeConstructor.INSTANCE);
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.ascii();
        functionFactory.char_chr();
        functionFactory.overlay();
        functionFactory.position();
        functionFactory.substringFromFor();
        functionFactory.locate_positionSubstring();
        functionFactory.concat_pipeOperator();
        functionFactory.trim2();
        functionFactory.substr();
        functionFactory.reverse();
        functionFactory.repeat();
        functionFactory.sha1();
        functionFactory.octetLength();
        functionFactory.bitLength();
        functionFactory.cbrt();
        functionFactory.cot();
        functionFactory.degrees();
        functionFactory.radians();
        functionFactory.pi();
        functionFactory.log();
        functionFactory.log10_log();
        functionFactory.round();
        functionFactory.bitandorxornot_operator();
        functionFactory.bitAndOr();
        functionFactory.everyAny_boolAndOr();
        functionFactory.median_percentileCont_castDouble();
        functionFactory.stddev();
        functionFactory.stddevPopSamp();
        functionFactory.variance();
        functionFactory.varPopSamp();
        functionFactory.covarPopSamp();
        functionFactory.corr();
        functionFactory.regrLinearRegressionAggregates();
        functionContributions.getFunctionRegistry().register("format", new FormatFunction("experimental_strftime", false, true, false, functionContributions.getTypeConfiguration()));
        functionFactory.windowFunctions();
        functionFactory.listagg_stringAgg("string");
        functionFactory.inverseDistributionOrderedSetAggregates();
        functionFactory.hypotheticalOrderedSetAggregates_windowEmulation();
        functionFactory.array_postgresql();
        functionFactory.arrayAggregate();
        functionFactory.arrayPosition_postgresql();
        functionFactory.arrayPositions_postgresql();
        functionFactory.arrayLength_cardinality();
        functionFactory.arrayConcat_postgresql();
        functionFactory.arrayPrepend_postgresql();
        functionFactory.arrayAppend_postgresql();
        functionFactory.arrayContains_postgresql();
        functionFactory.arrayIntersects_postgresql();
        functionFactory.arrayGet_bracket();
        functionFactory.arraySet_unnest();
        functionFactory.arrayRemove();
        functionFactory.arrayRemoveIndex_unnest(true);
        functionFactory.arraySlice_operator();
        functionFactory.arrayReplace();
        functionFactory.arrayTrim_unnest();
        functionFactory.arrayFill_cockroachdb();
        functionFactory.arrayToString_postgresql();
        functionFactory.jsonValue_cockroachdb();
        functionFactory.jsonQuery_cockroachdb();
        functionFactory.jsonExists_cockroachdb();
        functionFactory.jsonObject_postgresql();
        functionFactory.jsonArray_postgresql();
        functionFactory.jsonArrayAgg_postgresql(false);
        functionFactory.jsonObjectAgg_postgresql(false);
        functionFactory.jsonSet_postgresql();
        functionFactory.jsonRemove_cockroachdb();
        functionFactory.jsonReplace_postgresql();
        functionFactory.jsonInsert_postgresql();
        functionFactory.jsonArrayAppend_postgresql(false);
        functionFactory.jsonArrayInsert_postgresql();
        functionFactory.unnest_postgresql(false);
        functionFactory.generateSeries(null, "ordinality", true);
        functionFactory.jsonTable_cockroachdb();
        functionContributions.getFunctionRegistry().patternDescriptorBuilder("bitxor", "(?1#?2)").setExactArgumentCount(2).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
        functionContributions.getFunctionRegistry().register("trunc", new PostgreSQLTruncFunction(true, functionContributions.getTypeConfiguration()));
        functionContributions.getFunctionRegistry().registerAlternateKey("truncate", "trunc");
        functionFactory.hex("encode(?1, 'hex')");
        functionFactory.sha("digest(?1, 'sha256')");
        functionFactory.md5("digest(?1, 'md5')");
    }

    @Override
    public @Nullable String getDefaultOrdinalityColumnName() {
        return "ordinality";
    }

    @Override
    public TimeZoneSupport getTimeZoneSupport() {
        return TimeZoneSupport.NORMALIZE;
    }

    @Override
    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        appender.appendSql(bool);
    }

    @Override
    public String getCascadeConstraintsString() {
        return " cascade";
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select now()";
    }

    @Override
    public boolean supportsDistinctFromPredicate() {
        return true;
    }

    @Override
    public boolean supportsIfExistsBeforeTableName() {
        return true;
    }

    @Override
    public boolean supportsIfExistsBeforeConstraintName() {
        return true;
    }

    @Override
    public boolean supportsIfExistsAfterAlterTable() {
        return true;
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return CockroachDBIdentityColumnSupport.INSTANCE;
    }

    @Override
    public boolean supportsValuesList() {
        return true;
    }

    @Override
    public boolean supportsPartitionBy() {
        return true;
    }

    @Override
    public boolean supportsNonQueryWithCTE() {
        return true;
    }

    @Override
    public boolean supportsRecursiveCTE() {
        return true;
    }

    @Override
    public boolean supportsConflictClauseForInsertCTE() {
        return true;
    }

    @Override
    public String getNoColumnsInsertString() {
        return "default values";
    }

    @Override
    public String getCaseInsensitiveLike() {
        return "ilike";
    }

    @Override
    public boolean supportsCaseInsensitiveLike() {
        return true;
    }

    @Override
    public boolean supportsNullPrecedence() {
        return false;
    }

    @Override
    public NullOrdering getNullOrdering() {
        return NullOrdering.SMALLEST;
    }

    @Override
    public boolean supportsTupleCounts() {
        return true;
    }

    @Override
    public boolean requiresParensForTupleDistinctCounts() {
        return true;
    }

    @Override
    public GenerationType getNativeValueGenerationStrategy() {
        return GenerationType.SEQUENCE;
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return PostgreSQLSequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return "select sequence_name,sequence_schema,sequence_catalog,start_value,minimum_value,maximum_value,increment from information_schema.sequences";
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, org.hibernate.sql.ast.tree.Statement statement) {
                return new CockroachSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public NationalizationSupport getNationalizationSupport() {
        return NationalizationSupport.IMPLICIT;
    }

    @Override
    public AggregateSupport getAggregateSupport() {
        return CockroachDBAggregateSupport.valueOf(this);
    }

    @Override
    public int getMaxIdentifierLength() {
        return 63;
    }

    @Override
    public boolean supportsStandardArrays() {
        return true;
    }

    @Override
    public boolean supportsTemporalLiteralOffset() {
        return true;
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, temporalAccessor);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                if (this.supportsTemporalLiteralOffset() && temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                    appender.appendSql("time with time zone '");
                    DateTimeUtils.appendAsTime(appender, temporalAccessor, true, jdbcTimeZone);
                } else {
                    appender.appendSql("time '");
                    DateTimeUtils.appendAsLocalTime(appender, temporalAccessor);
                }
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                if (this.supportsTemporalLiteralOffset() && temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                    appender.appendSql("timestamp with time zone '");
                    DateTimeUtils.appendAsTimestampWithMicros(appender, temporalAccessor, true, jdbcTimeZone);
                    appender.appendSql('\'');
                    break;
                }
                appender.appendSql("timestamp '");
                DateTimeUtils.appendAsTimestampWithMicros(appender, temporalAccessor, false, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, date);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time with time zone '");
                DateTimeUtils.appendAsTime(appender, date, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp with time zone '");
                DateTimeUtils.appendAsTimestampWithMicros(appender, date, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Calendar calendar, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, calendar);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time with time zone '");
                DateTimeUtils.appendAsTime(appender, calendar, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp with time zone '");
                DateTimeUtils.appendAsTimestampWithMillis(appender, calendar, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        return switch (unit) {
            case TemporalUnit.DAY_OF_WEEK -> "(" + super.extractPattern(unit) + "+1)";
            default -> super.extractPattern(unit);
        };
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        return switch (unit) {
            case TemporalUnit.DAY_OF_MONTH -> "day";
            case TemporalUnit.DAY_OF_YEAR -> "dayofyear";
            case TemporalUnit.DAY_OF_WEEK -> "dayofweek";
            default -> super.translateExtractField(unit);
        };
    }

    @Override
    public long getFractionalSecondPrecisionInNanos() {
        return 1000L;
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        return intervalType != null ? "(?2+?3)" : "cast(?3+" + CockroachDialect.intervalPattern(unit) + " as " + temporalType.name().toLowerCase() + ")";
    }

    private static String intervalPattern(TemporalUnit unit) {
        return switch (unit) {
            case TemporalUnit.NATIVE -> "(?2)*interval '1 microsecond'";
            case TemporalUnit.NANOSECOND -> "(?2)/1e3*interval '1 microsecond'";
            case TemporalUnit.QUARTER -> "(?2)*interval '3 month'";
            case TemporalUnit.WEEK -> "(?2)*interval '7 day'";
            default -> "(?2)*interval '1 " + String.valueOf((Object)unit) + "'";
        };
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        if (unit == null) {
            return "(?3-?2)";
        }
        if (toTemporalType == TemporalType.DATE && fromTemporalType == TemporalType.DATE) {
            return switch (unit) {
                case TemporalUnit.QUARTER, TemporalUnit.YEAR, TemporalUnit.MONTH -> "extract(" + this.translateDurationField(unit) + " from age(cast(?3 as timestamptz),cast(?2 as timestamptz)))";
                default -> "(?3-?2)" + TemporalUnit.DAY.conversionFactor(unit, this);
            };
        }
        return switch (unit) {
            case TemporalUnit.YEAR -> "extract(year from ?3-?2)";
            case TemporalUnit.QUARTER -> "(extract(year from ?3-?2)*4+extract(month from ?3-?2)//3)";
            case TemporalUnit.MONTH -> "(extract(year from ?3-?2)*12+extract(month from ?3-?2))";
            case TemporalUnit.WEEK -> "(extract(day from ?3-?2)/7)";
            case TemporalUnit.DAY -> "extract(day from ?3-?2)";
            case TemporalUnit.NATIVE, TemporalUnit.NANOSECOND, TemporalUnit.HOUR, TemporalUnit.MINUTE, TemporalUnit.SECOND -> "round(extract(epoch from ?3-?2)" + TemporalUnit.EPOCH.conversionFactor(unit, this) + ")::int";
            default -> throw new SemanticException("Unrecognized field: " + String.valueOf((Object)unit));
        };
    }

    @Override
    public String translateDurationField(TemporalUnit unit) {
        return unit == TemporalUnit.NATIVE ? "microsecond" : super.translateDurationField(unit);
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(SpannerDialect.datetimeFormat(format).result());
    }

    @Override
    public LimitHandler getLimitHandler() {
        return OffsetFetchLimitHandler.INSTANCE;
    }

    @Override
    public LockingSupport getLockingSupport() {
        return CockroachLockingSupport.COCKROACH_LOCKING_SUPPORT;
    }

    @Override
    public String getForUpdateString(String aliases) {
        return this.getForUpdateString() + " of " + aliases;
    }

    @Override
    public String getForUpdateString(LockOptions lockOptions) {
        return super.getForUpdateString(lockOptions);
    }

    @Override
    public String getForUpdateString(String aliases, LockOptions lockOptions) {
        LockMode lockMode = lockOptions.getLockMode();
        return switch (lockMode) {
            case LockMode.PESSIMISTIC_READ -> this.getReadLockString(aliases, lockOptions.getTimeout());
            case LockMode.PESSIMISTIC_WRITE -> this.getWriteLockString(aliases, lockOptions.getTimeout());
            case LockMode.UPGRADE_NOWAIT, LockMode.PESSIMISTIC_FORCE_INCREMENT -> this.getForUpdateNowaitString(aliases);
            case LockMode.UPGRADE_SKIPLOCKED -> this.getForUpdateSkipLockedString(aliases);
            default -> "";
        };
    }

    private String withTimeout(String lockString, Timeout timeout) {
        return this.withTimeout(lockString, timeout.milliseconds());
    }

    private String withTimeout(String lockString, int timeout) {
        return switch (timeout) {
            case 0 -> {
                if (this.supportsNoWait()) {
                    yield lockString + " nowait";
                }
                yield lockString;
            }
            case -2 -> {
                if (this.supportsSkipLocked()) {
                    yield lockString + " skip locked";
                }
                yield lockString;
            }
            default -> lockString;
        };
    }

    @Override
    public String getWriteLockString(Timeout timeout) {
        return this.withTimeout(this.getForUpdateString(), timeout);
    }

    @Override
    public String getWriteLockString(String aliases, Timeout timeout) {
        return this.withTimeout(this.getForUpdateString(aliases), timeout);
    }

    @Override
    public String getReadLockString(Timeout timeout) {
        return this.withTimeout(" for share", timeout);
    }

    @Override
    public String getReadLockString(String aliases, Timeout timeout) {
        return this.withTimeout(" for share of " + aliases, timeout);
    }

    @Override
    public String getForUpdateNowaitString() {
        return this.supportsNoWait() ? this.getForUpdateString() + " nowait" : this.getForUpdateString();
    }

    @Override
    public String getForUpdateNowaitString(String aliases) {
        return this.supportsNoWait() ? this.getForUpdateString(aliases) + " nowait" : this.getForUpdateString(aliases);
    }

    @Override
    public String getForUpdateSkipLockedString() {
        return this.supportsSkipLocked() ? this.getForUpdateString() + " skip locked" : this.getForUpdateString();
    }

    @Override
    public String getForUpdateSkipLockedString(String aliases) {
        return this.supportsSkipLocked() ? this.getForUpdateString(aliases) + " skip locked" : this.getForUpdateString(aliases);
    }

    @Override
    public boolean useInputStreamToInsertBlob() {
        return false;
    }

    @Override
    public boolean useConnectionToCreateLob() {
        return false;
    }

    @Override
    public boolean supportsOffsetInSubquery() {
        return true;
    }

    @Override
    public boolean supportsWindowFunctions() {
        return true;
    }

    @Override
    public boolean supportsLateral() {
        return true;
    }

    @Override
    public FunctionalDependencyAnalysisSupport getFunctionalDependencyAnalysisSupport() {
        return FunctionalDependencyAnalysisSupportImpl.TABLE_REFERENCE;
    }

    @Override
    public NameQualifierSupport getNameQualifierSupport() {
        return NameQualifierSupport.SCHEMA;
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData metadata) throws SQLException {
        if (metadata == null) {
            builder.setUnquotedCaseStrategy(IdentifierCaseStrategy.LOWER);
            builder.setQuotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        }
        return super.buildIdentifierHelper(builder, metadata);
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            JDBCException jDBCException;
            String sqlState = JdbcExceptionHelper.extractSqlState(sqlException);
            if (sqlState == null) {
                jDBCException = null;
            } else {
                switch (sqlState) {
                    case "40001": {
                        if (message.contains("WriteTooOldError")) {
                            jDBCException = new TransactionSerializationException(message, sqlException, sql);
                            break;
                        }
                        jDBCException = null;
                        break;
                    }
                    case "40P01": {
                        jDBCException = new LockAcquisitionException(message, sqlException, sql);
                        break;
                    }
                    case "55P03": {
                        jDBCException = new LockTimeoutException(message, sqlException, sql);
                        break;
                    }
                    case "57014": {
                        jDBCException = new QueryTimeoutException(message, sqlException, sql);
                        break;
                    }
                    default: {
                        jDBCException = null;
                    }
                }
            }
            return jDBCException;
        };
    }

    @Override
    public String getQueryHintString(String query, List<String> hintList) {
        return new CockroachDialectQueryHints(query, hintList).getQueryHintString();
    }

    @Override
    public int getDefaultIntervalSecondScale() {
        return 6;
    }

    @Override
    public DmlTargetColumnQualifierSupport getDmlTargetColumnQualifierSupport() {
        return DmlTargetColumnQualifierSupport.TABLE_ALIAS;
    }

    @Override
    public boolean supportsFromClauseInUpdate() {
        return true;
    }

    @Override
    public boolean supportsRowConstructor() {
        return true;
    }

    @Override
    public boolean supportsArrayConstructor() {
        return true;
    }

    @Override
    public boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    @Override
    public String getWriteLockString(int timeout) {
        return this.withTimeout(this.getForUpdateString(), timeout);
    }

    @Override
    public String getWriteLockString(String aliases, int timeout) {
        return this.withTimeout(this.getForUpdateString(aliases), timeout);
    }

    @Override
    public String getReadLockString(int timeout) {
        return this.withTimeout(" for share", timeout);
    }

    @Override
    public String getReadLockString(String aliases, int timeout) {
        return this.withTimeout(" for share of " + aliases, timeout);
    }
}

