/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.quarkus.arc.Arc;
import io.quarkus.resteasy.reactive.jackson.runtime.security.RolesAllowedConfigExpStorage;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.GeneratedSerializersRegister;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;

@Recorder
public class ResteasyReactiveServerJacksonRecorder {
    private static final Map<String, Class<?>> jsonViewMap = new HashMap();
    private static final Map<String, Class<?>> customSerializationMap = new HashMap();
    private static final Map<String, Class<?>> customDeserializationMap = new HashMap();

    public RuntimeValue<Map<String, Supplier<String[]>>> createConfigExpToAllowedRoles() {
        return new RuntimeValue(new ConcurrentHashMap());
    }

    public BiConsumer<String, Supplier<String[]>> recordRolesAllowedConfigExpression(final RuntimeValue<Map<String, Supplier<String[]>>> configExpToAllowedRoles) {
        return new BiConsumer<String, Supplier<String[]>>(){

            @Override
            public void accept(String configKey, Supplier<String[]> configValueSupplier) {
                ((Map)configExpToAllowedRoles.getValue()).put(configKey, configValueSupplier);
            }
        };
    }

    public Supplier<RolesAllowedConfigExpStorage> createRolesAllowedConfigExpStorage(final RuntimeValue<Map<String, Supplier<String[]>>> configExpToAllowedRoles) {
        return new Supplier<RolesAllowedConfigExpStorage>(){

            @Override
            public RolesAllowedConfigExpStorage get() {
                Map map = (Map)configExpToAllowedRoles.getValue();
                if (map.isEmpty()) {
                    throw new IllegalStateException("The 'RolesAllowedConfigExpStorage' bean is created before runtime configuration is ready");
                }
                return new RolesAllowedConfigExpStorage((Map)configExpToAllowedRoles.getValue());
            }
        };
    }

    public void initAndValidateRolesAllowedConfigExp() {
        ((RolesAllowedConfigExpStorage)Arc.container().instance(RolesAllowedConfigExpStorage.class, new Annotation[0]).get()).resolveRolesAllowedConfigExp();
    }

    public void recordJsonView(String targetId, String className) {
        jsonViewMap.put(targetId, this.loadClass(className));
    }

    public void recordCustomSerialization(String target, String className) {
        customSerializationMap.put(target, this.loadClass(className));
    }

    public void recordCustomDeserialization(String target, String className) {
        customDeserializationMap.put(target, this.loadClass(className));
    }

    public void recordGeneratedSerializer(String className) {
        GeneratedSerializersRegister.addSerializer(this.loadClass(className));
    }

    public void recordGeneratedDeserializer(String className) {
        GeneratedSerializersRegister.addDeserializer(this.loadClass(className));
    }

    public void configureShutdown(ShutdownContext shutdownContext) {
        shutdownContext.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                jsonViewMap.clear();
                customSerializationMap.clear();
                customDeserializationMap.clear();
            }
        });
    }

    public static Class<?> jsonViewForClass(Class<?> clazz) {
        return jsonViewMap.get(clazz.getName());
    }

    public static Class<?> jsonViewForMethod(String methodId) {
        return jsonViewMap.get(methodId);
    }

    public static Class<? extends BiFunction<ObjectMapper, Type, ObjectWriter>> customSerializationForMethod(String methodId) {
        return customSerializationMap.get(methodId);
    }

    public static Class<? extends BiFunction<ObjectMapper, Type, ObjectWriter>> customSerializationForClass(Class<?> clazz) {
        return customSerializationMap.get(clazz.getName());
    }

    public static Class<? extends BiFunction<ObjectMapper, Type, ObjectReader>> customDeserializationForMethod(String methodId) {
        return customDeserializationMap.get(methodId);
    }

    public static Class<? extends BiFunction<ObjectMapper, Type, ObjectReader>> customDeserializationForClass(Class<?> clazz) {
        return customDeserializationMap.get(clazz.getName());
    }

    private Class<?> loadClass(String className) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load class '" + className + "' for supporting custom JSON serialization", e);
        }
    }
}

