/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.settings;

import java.io.File;
import org.aesh.command.activator.CommandActivator;
import org.aesh.command.activator.OptionActivator;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.converter.ConverterInvocation;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.settings.Settings;
import org.aesh.command.settings.SettingsBuilder;
import org.aesh.command.validator.ValidatorInvocation;
import org.aesh.io.FileResource;
import org.aesh.readline.editing.EditMode;

public class RuntimeSettings {
    public static Settings<CommandInvocation, ConverterInvocation, CompleterInvocation, ValidatorInvocation, OptionActivator, CommandActivator> readRuntimeProperties(Settings<CommandInvocation, ConverterInvocation, CompleterInvocation, ValidatorInvocation, OptionActivator, CommandActivator> settings) {
        FileResource resourceFile;
        String executeFile;
        String execute;
        String disableCompletion;
        String logFile;
        String doLogging;
        String historySize;
        String historyDisabled;
        String historyPersistent;
        String historyFile;
        String inputrc;
        String readInputrc;
        SettingsBuilder<CommandInvocation, ConverterInvocation, CompleterInvocation, ValidatorInvocation, OptionActivator, CommandActivator> builder = new SettingsBuilder<CommandInvocation, ConverterInvocation, CompleterInvocation, ValidatorInvocation, OptionActivator, CommandActivator>(settings);
        String editMode = System.getProperty("aesh.editmode");
        if (editMode != null && editMode.length() > 0) {
            if (editMode.equalsIgnoreCase("VI")) {
                builder.mode(EditMode.Mode.VI);
            } else if (editMode.equalsIgnoreCase("EMACS")) {
                builder.mode(EditMode.Mode.EMACS);
            }
        }
        if ((readInputrc = System.getProperty("aesh.readinputrc")) != null && readInputrc.length() > 0 && (readInputrc.equalsIgnoreCase("true") || readInputrc.equalsIgnoreCase("false"))) {
            builder.readInputrc(Boolean.parseBoolean(readInputrc));
        }
        if ((inputrc = System.getProperty("aesh.inputrc")) != null && inputrc.length() > 0 && new File(inputrc).isFile()) {
            builder.inputrc(new File(inputrc));
        }
        if ((historyFile = System.getProperty("aesh.historyfile")) != null && historyFile.length() > 0 && new File(historyFile).isFile()) {
            builder.historyFile(new File(historyFile));
        }
        if ((historyPersistent = System.getProperty("aesh.historypersistent")) != null && historyPersistent.length() > 0 && (historyPersistent.equalsIgnoreCase("true") || historyPersistent.equalsIgnoreCase("false"))) {
            builder.persistHistory(Boolean.parseBoolean(historyPersistent));
        }
        if ((historyDisabled = System.getProperty("aesh.historydisabled")) != null && historyDisabled.length() > 0 && (historyDisabled.equalsIgnoreCase("true") || historyDisabled.equalsIgnoreCase("false"))) {
            builder.disableHistory(Boolean.parseBoolean(historyDisabled));
        }
        if ((historySize = System.getProperty("aesh.historysize")) != null && historySize.length() > 0) {
            builder.historySize(Integer.parseInt(historySize));
        }
        if ((doLogging = System.getProperty("aesh.logging")) != null && doLogging.length() > 0 && (doLogging.equalsIgnoreCase("true") || doLogging.equalsIgnoreCase("false"))) {
            builder.logging(Boolean.parseBoolean(doLogging));
        }
        if ((logFile = System.getProperty("aesh.logfile")) != null && logFile.length() > 0) {
            builder.logfile(logFile);
        }
        if ((disableCompletion = System.getProperty("aesh.disablecompletion")) != null && disableCompletion.length() > 0 && (disableCompletion.equalsIgnoreCase("true") || disableCompletion.equalsIgnoreCase("false"))) {
            builder.disableCompletion(Boolean.parseBoolean(disableCompletion));
        }
        if ((execute = System.getProperty("aesh.execute")) != null && execute.length() > 0) {
            builder.setExecuteAtStart(execute);
        }
        if ((executeFile = System.getProperty("aesh.executefile")) != null && executeFile.length() > 0 && (resourceFile = new FileResource(executeFile)).isLeaf()) {
            builder.setExecuteFileAtStart(resourceFile);
        }
        return builder.build();
    }
}

