/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.UserModelDelegate;
import org.keycloak.storage.ReadOnlyException;
import org.keycloak.storage.ldap.LDAPStorageProvider;

public class ReadonlyLDAPUserModelDelegate
extends UserModelDelegate {
    public ReadonlyLDAPUserModelDelegate(UserModel delegate) {
        super(delegate);
    }

    public void setUsername(String username) {
        if (!Objects.equals(this.getUsername(), username)) {
            throw new ReadOnlyException("Federated storage is not writable");
        }
    }

    public void setLastName(String lastName) {
        if (!Objects.equals(this.getLastName(), lastName)) {
            throw new ReadOnlyException("Federated storage is not writable");
        }
    }

    public void setFirstName(String first) {
        if (!Objects.equals(this.getFirstName(), first)) {
            throw new ReadOnlyException("Federated storage is not writable");
        }
    }

    public void setEmail(String email) {
        if (!Objects.equals(this.getEmail(), email)) {
            throw new ReadOnlyException("Federated storage is not writable");
        }
    }

    public void setSingleAttribute(String name, String value) {
        this.setAttribute(name, value != null ? List.of(value) : null);
    }

    public void setAttribute(String name, List<String> values) {
        if (LDAPStorageProvider.INTERNAL_ATTRIBUTES.contains(name)) {
            super.setAttribute(name, values);
            return;
        }
        if (!Objects.equals(this.getAttributeStream(name).collect(Collectors.toList()), values)) {
            throw new ReadOnlyException("Federated storage is not writable");
        }
    }

    public void removeAttribute(String name) {
        if (LDAPStorageProvider.INTERNAL_ATTRIBUTES.contains(name)) {
            super.removeAttribute(name);
            return;
        }
        if (this.getAttributeStream(name).count() > 0L) {
            throw new ReadOnlyException("Federated storage is not writable");
        }
    }
}

