/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.embeddable.internal;

import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.embeddable.AggregateEmbeddableResultGraphNode;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableInitializerImpl;
import org.hibernate.sql.results.graph.embeddable.internal.NestedRowProcessingState;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class AggregateEmbeddableInitializerImpl
extends EmbeddableInitializerImpl {
    private final int[] aggregateValuesArrayPositions;

    public AggregateEmbeddableInitializerImpl(AggregateEmbeddableResultGraphNode resultDescriptor, BasicFetch<?> discriminatorFetch, InitializerParent<?> parent, AssemblerCreationState creationState, boolean isResultInitializer) {
        super(resultDescriptor, discriminatorFetch, null, parent, creationState, isResultInitializer);
        this.aggregateValuesArrayPositions = resultDescriptor.getAggregateValuesArrayPositions();
    }

    @Override
    public void startLoading(RowProcessingState rowProcessingState) {
        super.startLoading(NestedRowProcessingState.wrap(this, rowProcessingState));
    }

    @Override
    protected void extractRowState(EmbeddableInitializerImpl.EmbeddableInitializerData data) {
        super.extractRowState(data);
        if (data.getState() == Initializer.State.MISSING && !this.isPartOfKey() && this.getJdbcValues(data.getRowProcessingState().unwrap()) != null) {
            data.setState(Initializer.State.RESOLVED);
        }
    }

    public int[] getAggregateValuesArrayPositions() {
        return this.aggregateValuesArrayPositions;
    }

    public Object[] getJdbcValues(RowProcessingState processingState) {
        int[] aggregateValuesArrayPositions = this.getAggregateValuesArrayPositions();
        Object[] jdbcValue = (Object[])processingState.getJdbcValue(aggregateValuesArrayPositions[0]);
        for (int i = 1; i < aggregateValuesArrayPositions.length && jdbcValue != null; ++i) {
            jdbcValue = (Object[])jdbcValue[aggregateValuesArrayPositions[i]];
        }
        return jdbcValue;
    }
}

