/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.text;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.text.XPageCursor;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextViewCursor;
import com.sun.star.text.XTextViewCursorSupplier;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.XViewSettingsSupplier;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.text.TextTableHandler;

public class ViewHandler {
    private final XTextViewCursorSupplier xTextViewCursorSupplier;
    private final XStyleFamiliesSupplier xStyleFamiliesSupplier;
    private final XViewSettingsSupplier xViewSettingsSupplier;

    public ViewHandler(XTextDocument xTextDocument) {
        this.xTextViewCursorSupplier = (XTextViewCursorSupplier)UnoRuntime.queryInterface(XTextViewCursorSupplier.class, (Object)xTextDocument.getCurrentController());
        this.xViewSettingsSupplier = (XViewSettingsSupplier)UnoRuntime.queryInterface(XViewSettingsSupplier.class, (Object)xTextDocument.getCurrentController());
        this.xStyleFamiliesSupplier = (XStyleFamiliesSupplier)UnoRuntime.queryInterface(XStyleFamiliesSupplier.class, (Object)xTextDocument);
    }

    public void selectFirstPage(TextTableHandler textTableHandler) {
        try {
            XPageCursor xPageCursor = (XPageCursor)UnoRuntime.queryInterface(XPageCursor.class, (Object)this.xTextViewCursorSupplier.getViewCursor());
            XTextCursor xTextCursor = (XTextCursor)UnoRuntime.queryInterface(XTextCursor.class, (Object)xPageCursor);
            xPageCursor.jumpToFirstPage();
            xPageCursor.jumpToStartOfPage();
            Helper.setUnoPropertyValue(xPageCursor, "PageDescName", "First Page");
            Object object = this.xStyleFamiliesSupplier.getStyleFamilies().getByName("PageStyles");
            XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)object);
            Object object2 = xNameAccess.getByName("First Page");
            XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)textTableHandler.xTextTablesSupplier.getTextTables());
            XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)xIndexAccess.getByIndex(0));
            XTextRange xTextRange = (XTextRange)UnoRuntime.queryInterface(XTextRange.class, (Object)xTextContent.getAnchor().getText());
            xTextCursor.gotoRange(xTextRange, false);
            XTextRange xTextRange2 = (XTextRange)Helper.getUnoPropertyValue(object2, "HeaderText", XTextRange.class);
            if (!AnyConverter.isVoid((Object)xTextRange2)) {
                xTextCursor.gotoRange(xTextRange2, false);
                xTextCursor.collapseToStart();
            } else {
                System.out.println("No Headertext available");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void setViewSetting(String string, Object object) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        this.xViewSettingsSupplier.getViewSettings().setPropertyValue(string, object);
    }

    public void collapseViewCursorToStart() {
        XTextViewCursor xTextViewCursor = this.xTextViewCursorSupplier.getViewCursor();
        xTextViewCursor.collapseToStart();
    }
}

