var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/dfa/DFAState.ts
var DFAState_exports = {};
__export(DFAState_exports, {
  DFAState: () => DFAState
});
module.exports = __toCommonJS(DFAState_exports);

// src/utils/helpers.ts
var valueToString = /* @__PURE__ */ __name((v) => {
  return v === null ? "null" : v;
}, "valueToString");
var arrayToString = /* @__PURE__ */ __name((value) => {
  return Array.isArray(value) ? "[" + value.map(valueToString).join(", ") + "]" : "null";
}, "arrayToString");

// src/dfa/DFAState.ts
var DFAState = class _DFAState {
  static {
    __name(this, "DFAState");
  }
  stateNumber = -1;
  configs;
  /**
   * `edges[symbol]` points to target of symbol. Shift up by 1 so (-1) {@link Token.EOF} maps to `edges[0]`.
   */
  edges = [];
  isAcceptState = false;
  /**
   * If accept state, what ttype do we match or alt do we predict? This is set to {@link ATN.INVALID_ALT_NUMBER}
   * when {@link predicates} `!= null` or {@link requiresFullContext}.
   */
  prediction = -1;
  lexerActionExecutor = null;
  /**
   * Indicates that this state was created during SLL prediction that discovered a conflict between the configurations
   * in the state. Future {@link ParserATNSimulator.execATN} invocations immediately jumped doing
   * full context prediction if this field is true.
   */
  requiresFullContext = false;
  /**
   * During SLL parsing, this is a list of predicates associated with the ATN configurations of the DFA state.
   * When we have predicates, {@link requiresFullContext} is `false` since full context prediction evaluates
   * predicates on-the-fly. If this is not null, then {@link prediction} is `ATN.INVALID_ALT_NUMBER`.
   *
   * We only use these for non-{@link #requiresFullContext} but conflicting states. That
   * means we know from the context (it's $ or we don't dip into outer
   * context) that it's an ambiguity not a conflict.
   *
   * This list is computed by {@link ParserATNSimulator#predicateDFAState}.
   */
  predicates = null;
  constructor(configs) {
    if (configs) {
      this.configs = configs;
    }
  }
  static fromState(stateNumber) {
    const result = new _DFAState();
    result.stateNumber = stateNumber;
    return result;
  }
  static fromConfigs(configs) {
    return new _DFAState(configs);
  }
  static hashCode(state) {
    return state.configs.hashCode();
  }
  /**
   * Two {@link DFAState} instances are equal if their ATN configuration sets
   * are the same. This method is used to see if a state already exists.
   *
   * Because the number of alternatives and number of ATN configurations are
   * finite, there is a finite number of DFA states that can be processed.
   * This is necessary to show that the algorithm terminates.
   *
   * Cannot test the DFA state numbers here because in
   * {@link ParserATNSimulator#addDFAState} we need to know if any other state
   * exists that has this exact set of ATN configurations. The
   * {@link #stateNumber} is irrelevant.
   *
   * @param a The first {@link DFAState}.
   * @param b The second {@link DFAState}.
   *
   * @returns `true` if the two states are equal, otherwise `false`.
   */
  static equals(a, b) {
    return a.configs.equals(b.configs);
  }
  /**
   * @returns the set of all alts mentioned by all ATN configurations in this DFA state.
   */
  getAltSet() {
    const alts = /* @__PURE__ */ new Set();
    for (const config of this.configs) {
      alts.add(config.alt);
    }
    if (alts.size === 0) {
      return null;
    }
    return alts;
  }
  toString() {
    let buf = "";
    buf += this.stateNumber;
    buf += ":";
    buf += this.configs ? this.configs.toString() : "";
    if (this.isAcceptState) {
      buf += "=>";
      if (this.predicates) {
        buf += arrayToString(this.predicates);
      } else {
        buf += this.prediction;
      }
    }
    return buf.toString();
  }
};
