export interface ITftpOptions {
    host: string;
    port: number;
    root: string;
    denyPUT: boolean;
}
export interface IDhcpOptions {
    subnet: string;
    host: string;
    tftpserver: string;
    bios_filename: string;
    efi32_filename: string;
    efi64_filename: string;
    broadcast: string;
}
export interface IDhcpd {
    pre_init: (pkt: IPacket) => void;
    discover: (pkt: IPacket) => void;
    request: (pkt: IPacket) => void;
    inform: (pkt: IPacket) => void;
    proxy_request: (pkt: IPacket) => IPacket;
}
export interface IProxy {
    bind: (port: number, addr: string, cb: any) => IPacket;
}
export interface IServer {
    bind: (port: number, addr: string, cb: any) => IPacket;
}
export interface IPacket {
    getRequestedIPAddress: () => string;
    op: (op: any) => IPacket;
    htype: (htype: any) => IPacket;
    hlen: (hlen: any) => IPacket;
    hops: (hops: any) => IPacket;
    xid: (xid: any) => IPacket;
    secs: (secs: any) => IPacket;
    flags: (flags: any) => IPacket;
    ciaddr: (ciaddr: string) => IPacket;
    siaddr: (siaddr: string) => IPacket;
    giaddr: (giaddr: string) => IPacket;
    chaddr: (chaddr: any) => IPacket;
    sname: (sname: any) => IPacket;
    fname: (fname: any) => IPacket;
    options: (options: any) => IPacket;
}
