import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_DeleteCachePolicyCommand, se_DeleteCachePolicyCommand } from "../protocols/Aws_restXml";
export { $Command };
export class DeleteCachePolicyCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("Cloudfront2020_05_31", "DeleteCachePolicy", {})
    .n("CloudFrontClient", "DeleteCachePolicyCommand")
    .f(void 0, void 0)
    .ser(se_DeleteCachePolicyCommand)
    .de(de_DeleteCachePolicyCommand)
    .build() {
}
