/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p1cycles;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.elk.alg.layered.LayeredPhases;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class DepthFirstCycleBreaker
implements ILayoutPhase<LayeredPhases, LGraph> {
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> INTERMEDIATE_PROCESSING_CONFIGURATION = LayoutProcessorConfiguration.create().addAfter(LayeredPhases.P5_EDGE_ROUTING, IntermediateProcessorStrategy.REVERSED_EDGE_RESTORER);
    private List<LNode> sources;
    private boolean[] visited;
    private boolean[] active;
    private List<LEdge> edgesToBeReversed;

    @Override
    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        return INTERMEDIATE_PROCESSING_CONFIGURATION;
    }

    @Override
    public void process(LGraph graph, IElkProgressMonitor monitor) {
        monitor.begin("Depth-first cycle removal", 1.0f);
        List<LNode> nodes = graph.getLayerlessNodes();
        int nodeCount = nodes.size();
        this.sources = new ArrayList<LNode>();
        this.visited = new boolean[nodeCount];
        this.active = new boolean[nodeCount];
        this.edgesToBeReversed = new ArrayList<LEdge>();
        int index = 0;
        for (LNode node : nodes) {
            node.id = index;
            if (Iterables.isEmpty(node.getIncomingEdges())) {
                this.sources.add(node);
            }
            ++index;
        }
        for (LNode source : this.sources) {
            this.dfs(source);
        }
        int i = 0;
        while (i < nodeCount) {
            if (!this.visited[i]) {
                LNode n = nodes.get(i);
                assert (n.id == i);
                this.dfs(n);
            }
            ++i;
        }
        for (LEdge edge : this.edgesToBeReversed) {
            edge.reverse(graph, true);
            graph.setProperty(InternalProperties.CYCLIC, (Object)true);
        }
        this.sources = null;
        this.visited = null;
        this.active = null;
        this.edgesToBeReversed = null;
        monitor.done();
    }

    private void dfs(LNode n) {
        if (this.visited[n.id]) {
            return;
        }
        this.visited[n.id] = true;
        this.active[n.id] = true;
        for (LEdge out : n.getOutgoingEdges()) {
            if (out.isSelfLoop()) continue;
            LNode target = out.getTarget().getNode();
            if (this.active[target.id]) {
                this.edgesToBeReversed.add(out);
                continue;
            }
            this.dfs(target);
        }
        this.active[n.id] = false;
    }
}

