/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.collections.concurrent;

import com.strobel.annotations.NotNull;
import com.strobel.collections.concurrent.ConcurrentRefValueIntObjectHashMap;
import com.strobel.core.Comparer;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

public final class ConcurrentWeakIntObjectHashMap<V>
extends ConcurrentRefValueIntObjectHashMap<V> {
    @Override
    protected final ConcurrentRefValueIntObjectHashMap.IntReference<V> createReference(int key, @NotNull V value, ReferenceQueue<V> queue) {
        return new WeakIntReference<V>(key, value, queue);
    }

    private static final class WeakIntReference<V>
    extends WeakReference<V>
    implements ConcurrentRefValueIntObjectHashMap.IntReference<V> {
        private final int _hash;
        private final int _key;

        WeakIntReference(int key, V referent, ReferenceQueue<? super V> q) {
            super(referent, q);
            this._key = key;
            this._hash = referent.hashCode();
        }

        @Override
        public final int key() {
            return this._key;
        }

        public final int hashCode() {
            return this._hash;
        }

        public final boolean equals(Object obj) {
            if (!(obj instanceof WeakIntReference)) {
                return false;
            }
            WeakIntReference other = (WeakIntReference)obj;
            return other._hash == this._hash && Comparer.equals(other.get(), this.get());
        }
    }
}

