/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.CaseLabel;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.NodeType;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.TokenRole;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Role;

public class SwitchExpressionArm
extends AstNode {
    public static final SwitchExpressionArm NULL = new NullSwitchExpressionArm();
    public static final Role<Expression> VALUE_ROLE = new Role<Expression>("Value", Expression.class, Expression.NULL);
    public static final TokenRole CASE_KEYWORD_ROLE = CaseLabel.CASE_KEYWORD_ROLE;
    public static final TokenRole DEFAULT_KEYWORD_ROLE = CaseLabel.DEFAULT_KEYWORD_ROLE;
    public static final TokenRole ARROW_ROLE = new TokenRole("->", 2);
    public static final TokenRole COLON_ROLE = new TokenRole(":", 4);
    private boolean defaultCase;
    private boolean isClassicStyle;

    public final AstNodeCollection<Statement> getStatements() {
        return this.getChildrenByRole(Roles.EMBEDDED_STATEMENT);
    }

    public final AstNodeCollection<Expression> getValues() {
        return this.getChildrenByRole(VALUE_ROLE);
    }

    public boolean isDefaultCase() {
        return this.defaultCase;
    }

    public void setDefaultCase(boolean defaultCase) {
        this.defaultCase = defaultCase;
    }

    public boolean isClassicStyle() {
        return this.isClassicStyle;
    }

    public void setClassicStyle(boolean classicStyle) {
        this.isClassicStyle = classicStyle;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.UNKNOWN;
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitSwitchExpressionArm(this, data);
    }

    public Role<? extends SwitchExpressionArm> getRole() {
        return super.getRole();
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof SwitchExpressionArm) {
            SwitchExpressionArm otherSection = (SwitchExpressionArm)other;
            return !otherSection.isNull() && this.getValues().matches(otherSection.getValues(), match) && this.getStatements().matches(otherSection.getStatements(), match);
        }
        return false;
    }

    private static final class NullSwitchExpressionArm
    extends SwitchExpressionArm {
        @Override
        public final boolean isNull() {
            return true;
        }

        @Override
        public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
            return null;
        }

        @Override
        public boolean matches(INode other, Match match) {
            return other == null || other.isNull();
        }
    }
}

