/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.treetable;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridSelection;
import com.intellij.database.datagrid.GridSelectionImpl;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.RawIndexConverter;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.SelectionModelWithViewColumns;
import com.intellij.database.datagrid.SelectionModelWithViewRows;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.selection.GridSelectionTracker;
import com.intellij.database.run.ui.grid.selection.GridSelectionTrackerImpl;
import com.intellij.database.run.ui.treetable.ColumnNode;
import com.intellij.database.run.ui.treetable.RowNode;
import com.intellij.database.run.ui.treetable.TreeTableResultView;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TreeTableSelectionModel
implements SelectionModel<GridRow, GridColumn>,
SelectionModelWithViewRows,
SelectionModelWithViewColumns {
    private final DataGrid myGrid;
    private final TreeTableResultView myView;
    private final GridSelectionTrackerImpl myTracker;

    TreeTableSelectionModel(@NotNull DataGrid grid, @NotNull TreeTableResultView view) {
        if (grid == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(0);
        }
        if (view == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(1);
        }
        this.myGrid = grid;
        this.myView = view;
        this.myTracker = new GridSelectionTrackerImpl(grid, view);
        this.myView.getComponent().putClientProperty("SelectionModel", this);
    }

    @NotNull
    public GridSelection<GridRow, GridColumn> store() {
        int[] viewRows = this.myView.getComponent().getTable().getSelectedRows();
        int[] modelRows = new int[viewRows.length];
        int[] modelColumns = new int[viewRows.length];
        for (int i = 0; i < viewRows.length; ++i) {
            Pair rowAndColumn = this.myGrid.getRawIndexConverter().rowAndColumn2Model().fun((Object)viewRows[i], (Object)0);
            modelRows[i] = (Integer)rowAndColumn.first;
            modelColumns[i] = (Integer)rowAndColumn.second;
        }
        return new GridSelectionImpl((ModelIndexSet<GridRow>)ModelIndexSet.forRows((CoreGrid)this.myGrid, (int[])modelRows), (ModelIndexSet<GridColumn>)ModelIndexSet.forColumns((CoreGrid)this.myGrid, (int[])modelColumns));
    }

    public void restore(@NotNull GridSelection<GridRow, GridColumn> selection) {
        if (selection == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(2);
        }
        RawIndexConverter converter = this.myGrid.getRawIndexConverter();
        for (ModelIndex modelRow : selection.getSelectedRows().asIterable()) {
            for (ModelIndex modelColumn : selection.getSelectedColumns().asIterable()) {
                Pair rowAndColumn = converter.rowAndColumn2View().fun((Object)modelRow.asInteger(), (Object)modelColumn.asInteger());
                int rowIdx = (Integer)rowAndColumn.first;
                if (!converter.isValidViewRowIdx(rowIdx)) continue;
                this.myView.getComponent().getTree().setSelectionRow(rowIdx);
            }
        }
    }

    @NotNull
    public GridSelection<GridRow, GridColumn> fit(@NotNull GridSelection<GridRow, GridColumn> selection) {
        if (selection == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(3);
        }
        return new GridSelectionImpl((ModelIndexSet<GridRow>)selection.getSelectedRows(), (ModelIndexSet<GridColumn>)selection.getSelectedColumns());
    }

    @NotNull
    public GridSelectionTracker getTracker() {
        GridSelectionTrackerImpl gridSelectionTrackerImpl = this.myTracker;
        if (gridSelectionTrackerImpl == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(4);
        }
        return gridSelectionTrackerImpl;
    }

    public void setRowSelection(@NotNull ModelIndexSet<GridRow> selection, boolean selectAtLeastOneCell) {
        if (selection == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(5);
        }
        this.myView.getComponent().getTree().clearSelection();
        this.addRowSelection(selection);
    }

    public void setSelection(@NotNull ModelIndexSet<GridRow> rows, @NotNull ModelIndexSet<GridColumn> columns) {
        if (rows == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(6);
        }
        if (columns == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(7);
        }
        RawIndexConverter converter = this.myGrid.getRawIndexConverter();
        ArrayList<Integer> selectedViewRows = new ArrayList<Integer>();
        for (ModelIndex rowIdx : rows.asIterable()) {
            for (ModelIndex columnIdx : columns.asIterable()) {
                Pair rowAndColumn = converter.rowAndColumn2View().fun((Object)rowIdx.asInteger(), (Object)columnIdx.asInteger());
                int viewRow = (Integer)rowAndColumn.first;
                if (!converter.isValidViewRowIdx(viewRow)) continue;
                selectedViewRows.add(viewRow);
            }
        }
        this.myView.getComponent().getTree().setSelectionRows(selectedViewRows.stream().mapToInt(x -> x).toArray());
    }

    public void setSelection(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (row == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(8);
        }
        if (column == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(9);
        }
        this.setSelection((ModelIndexSet<GridRow>)ModelIndexSet.forRows((CoreGrid)this.myGrid, (int[])new int[]{row.value}), (ModelIndexSet<GridColumn>)ModelIndexSet.forColumns((CoreGrid)this.myGrid, (int[])new int[]{column.value}));
    }

    public void setRowSelection(@NotNull ModelIndex<GridRow> selection, boolean selectAtLeastOneCell) {
        if (selection == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(10);
        }
        this.setRowSelection((ModelIndexSet<GridRow>)ModelIndexSet.forRows((CoreGrid)this.myGrid, (int[])new int[]{selection.value}), selectAtLeastOneCell);
    }

    public void addRowSelection(@NotNull ModelIndexSet<GridRow> selection) {
        if (selection == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(11);
        }
        for (ModelIndex rowIdx : selection.asIterable()) {
            ViewIndex viewIdx = rowIdx.toView((CoreGrid)this.myGrid);
            this.myView.getComponent().getTree().addSelectionRow(viewIdx.asInteger());
        }
    }

    public void setColumnSelection(@NotNull ModelIndexSet<GridColumn> selection, boolean selectAtLeastOneCell) {
        if (selection == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(12);
        }
        this.myView.getComponent().getTree().clearSelection();
        ModelIndexSet rows = this.getSelectedRows();
        if (rows.size() == 0 && selectAtLeastOneCell) {
            rows = ModelIndexSet.forRows((CoreGrid)this.myGrid, (int[])new int[]{0});
        }
        this.setSelection(rows, selection);
    }

    public void setColumnSelection(@NotNull ModelIndex<GridColumn> selection, boolean selectAtLeastOneCell) {
        if (selection == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(13);
        }
        this.setColumnSelection((ModelIndexSet<GridColumn>)ModelIndexSet.forColumns((CoreGrid)this.myGrid, (int[])new int[]{selection.value}), selectAtLeastOneCell);
    }

    public boolean isSelectionEmpty() {
        return this.myView.getComponent().getTree().isSelectionEmpty();
    }

    public boolean isSelected(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (row == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(14);
        }
        if (column == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(15);
        }
        Pair rowAndColumn = this.myView.getRawIndexConverter().rowAndColumn2View().fun((Object)row.asInteger(), (Object)column.asInteger());
        return this.myView.getComponent().getTable().isRowSelected(((Integer)rowAndColumn.first).intValue());
    }

    public boolean isSelected(@NotNull ViewIndex<GridRow> row, @NotNull ViewIndex<GridColumn> column) {
        if (row == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(16);
        }
        if (column == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(17);
        }
        return this.myView.getComponent().getTable().isRowSelected(row.asInteger());
    }

    public boolean isSelectedColumn(@NotNull ModelIndex<GridColumn> column) {
        if (column == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(18);
        }
        int viewColumn = this.myView.getRawIndexConverter().column2View().applyAsInt(column.asInteger());
        return this.myView.getComponent().getTable().isColumnSelected(viewColumn);
    }

    public boolean isSelectedRow(@NotNull ModelIndex<GridRow> row) {
        Object[] paths;
        if (row == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(19);
        }
        if ((paths = this.myView.getComponent().getTree().getSelectionPaths()) == null) {
            return false;
        }
        return ContainerUtil.find((Object[])paths, path -> ContainerUtil.find((Object[])path.getPath(), element -> element instanceof RowNode && ((RowNode)element).getRowIdx().equals((Object)row)) != null) != null;
    }

    public int getSelectedRowCount() {
        return this.getSelectedRows().size();
    }

    public int getSelectedColumnCount() {
        return this.getSelectedColumns().size();
    }

    public void selectWholeRow() {
        this.myGrid.getAutoscrollLocker().runWithLock(() -> this.setRowSelection(this.getSelectedRows(), true));
    }

    public void selectWholeColumn() {
        this.myGrid.getAutoscrollLocker().runWithLock(() -> {
            ModelIndexSet rows = this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getRowIndices();
            this.setSelection((ModelIndexSet<GridRow>)rows, this.getSelectedColumns());
        });
    }

    public void clearSelection() {
        this.myView.getComponent().getTree().clearSelection();
    }

    @NotNull
    public ModelIndex<GridRow> getSelectedRow() {
        TreePath path = this.myView.getComponent().getTree().getSelectionPath();
        RowNode rowNode = TreeTableSelectionModel.findNode(path, RowNode.class);
        ModelIndex modelIndex = rowNode == null ? ModelIndex.forRow((CoreGrid)this.myGrid, (int)-1) : rowNode.getRowIdx();
        if (modelIndex == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(20);
        }
        return modelIndex;
    }

    @Override
    public int selectedViewRowsCount() {
        return this.getSelectedRowCount();
    }

    @Override
    public int selectedViewColumnsCount() {
        return this.getSelectedColumnCount();
    }

    @Nullable
    private static <T> T findNode(@Nullable TreePath path, Class<? super T> aClass) {
        if (path == null) {
            return null;
        }
        return (T)ContainerUtil.find((Object[])path.getPath(), element -> Conditions.instanceOf((Class)aClass).value(element));
    }

    @NotNull
    public ModelIndexSet<GridRow> getSelectedRows() {
        Object[] paths = this.myView.getComponent().getTree().getSelectionPaths();
        if (paths == null) {
            ModelIndexSet modelIndexSet = ModelIndexSet.forRows((CoreGrid)this.myGrid, (int[])new int[0]);
            if (modelIndexSet == null) {
                TreeTableSelectionModel.$$$reportNull$$$0(21);
            }
            return modelIndexSet;
        }
        List rowNodes = ContainerUtil.mapNotNull((Object[])paths, path -> TreeTableSelectionModel.findNode(path, RowNode.class));
        List rowIndices = ContainerUtil.map((Collection)rowNodes, rowNode -> rowNode.getRowIdx().asInteger());
        ModelIndexSet modelIndexSet = ModelIndexSet.forRows((CoreGrid)this.myGrid, (int[])ArrayUtil.toIntArray((Collection)rowIndices));
        if (modelIndexSet == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(22);
        }
        return modelIndexSet;
    }

    @NotNull
    public ModelIndex<GridColumn> getSelectedColumn() {
        TreePath path = this.myView.getComponent().getTree().getSelectionPath();
        ColumnNode columnNode = TreeTableSelectionModel.findNode(path, ColumnNode.class);
        ModelIndex modelIndex = columnNode == null ? ModelIndex.forColumn((CoreGrid)this.myGrid, (int)-1) : columnNode.getColumnIdx();
        if (modelIndex == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(23);
        }
        return modelIndex;
    }

    @NotNull
    public ModelIndexSet<GridColumn> getSelectedColumns() {
        Object[] paths = this.myView.getComponent().getTree().getSelectionPaths();
        if (paths == null) {
            ModelIndexSet modelIndexSet = ModelIndexSet.forColumns((CoreGrid)this.myGrid, (int[])new int[0]);
            if (modelIndexSet == null) {
                TreeTableSelectionModel.$$$reportNull$$$0(24);
            }
            return modelIndexSet;
        }
        List columnNodes = ContainerUtil.mapNotNull((Object[])paths, path -> TreeTableSelectionModel.findNode(path, ColumnNode.class));
        List columnIndices = ContainerUtil.map((Collection)columnNodes, rowNode -> rowNode.getColumnIdx().asInteger());
        ModelIndexSet modelIndexSet = ModelIndexSet.forColumns((CoreGrid)this.myGrid, (int[])ArrayUtil.toIntArray((Collection)columnIndices));
        if (modelIndexSet == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(25);
        }
        return modelIndexSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 20, 21, 22, 23, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 4: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/treetable/TreeTableSelectionModel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 8: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 9: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/treetable/TreeTableSelectionModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTracker";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRow";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRows";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedColumn";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "restore";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fit";
                break;
            }
            case 4: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 5: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setRowSelection";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setSelection";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addRowSelection";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setColumnSelection";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isSelectedColumn";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isSelectedRow";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 20, 21, 22, 23, 24, 25 -> new IllegalStateException(string);
        };
    }
}

