/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.interop;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.interop.InteropMap;
import com.oracle.graal.python.runtime.interop.MergedPropertyNames;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedIntValueProfile;

@ExportLibrary(value=InteropLibrary.class)
public final class PythonMapScope
implements TruffleObject {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static final String[] TOP_SCOPE_NAMES = new String[]{"__main__", "builtins"};
    static final int LIMIT = 2;
    private final String[] names;
    private final Object[] objects;
    private final int scopeIndex;

    public PythonMapScope(Object[] objects, String[] names) {
        this(objects, 0, names);
    }

    private PythonMapScope(Object[] objects, int index, String[] names) {
        assert (objects.length == names.length);
        this.names = names;
        this.objects = objects;
        this.scopeIndex = index;
    }

    public static PythonMapScope createTopScope(PythonContext context) {
        Object[] objects = new Object[]{context.getMainModule(), InteropMap.fromPythonObject(context.getBuiltins())};
        return new PythonMapScope(objects, 0, TOP_SCOPE_NAMES);
    }

    @ExportMessage
    boolean hasScopeParent() {
        return this.scopeIndex < this.names.length - 1;
    }

    @ExportMessage
    Object getScopeParent() throws UnsupportedMessageException {
        if (this.scopeIndex < this.names.length - 1) {
            return new PythonMapScope(this.objects, this.scopeIndex + 1, this.names);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    Object getMembers(boolean includeInternal, @Bind Node inliningTarget, @Cached.Shared(value="interop") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached InlinedIntValueProfile lengthProfile) throws UnsupportedMessageException {
        int length = lengthProfile.profile(inliningTarget, this.names.length);
        Object[] keys = new Object[length - this.scopeIndex];
        for (int i = this.scopeIndex; i < length; ++i) {
            keys[i - this.scopeIndex] = interop.getMembers(this.objects[i]);
        }
        return new MergedPropertyNames(keys);
    }

    @ExportMessage
    boolean isMemberReadable(String member, @Bind Node inliningTarget, @Cached.Shared(value="interop") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached InlinedIntValueProfile lengthProfile) {
        int length = lengthProfile.profile(inliningTarget, this.names.length);
        for (int i = this.scopeIndex; i < length; ++i) {
            if (interop.isMemberReadable(this.objects[i], member)) {
                return true;
            }
            if (interop.isMemberExisting(this.objects[i], member)) break;
        }
        return false;
    }

    @ExportMessage
    Object readMember(String member, @Bind Node inliningTarget, @Cached.Shared(value="interop") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached InlinedIntValueProfile lengthProfile) throws UnknownIdentifierException, UnsupportedMessageException {
        int length = lengthProfile.profile(inliningTarget, this.names.length);
        for (int i = this.scopeIndex; i < length; ++i) {
            Object scope = this.objects[i];
            if (!interop.isMemberExisting(scope, member)) continue;
            return interop.readMember(scope, member);
        }
        throw UnknownIdentifierException.create((String)member);
    }

    @ExportMessage
    boolean isMemberModifiable(String member, @Bind Node inliningTarget, @Cached.Shared(value="interop") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached InlinedIntValueProfile lengthProfile) {
        int length = lengthProfile.profile(inliningTarget, this.names.length);
        for (int i = this.scopeIndex; i < length; ++i) {
            Object scope = this.objects[i];
            if (interop.isMemberModifiable(scope, member)) {
                return true;
            }
            if (interop.isMemberExisting(scope, member)) break;
        }
        return false;
    }

    @ExportMessage
    boolean isMemberInsertable(String member, @Bind Node inliningTarget, @Cached.Shared(value="interop") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached InlinedIntValueProfile lengthProfile) {
        int length = lengthProfile.profile(inliningTarget, this.names.length);
        for (int i = this.scopeIndex; i < length; ++i) {
            Object scope = this.objects[i];
            if (interop.isMemberInsertable(scope, member)) {
                return true;
            }
            if (!interop.isMemberExisting(scope, member)) continue;
            return false;
        }
        return false;
    }

    @ExportMessage
    boolean hasMemberReadSideEffects(String member, @Bind Node inliningTarget, @Cached.Shared(value="interop") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached InlinedIntValueProfile lengthProfile) {
        int length = lengthProfile.profile(inliningTarget, this.names.length);
        for (int i = this.scopeIndex; i < length; ++i) {
            Object scope = this.objects[i];
            if (!interop.isMemberReadable(scope, member)) continue;
            return interop.hasMemberReadSideEffects(scope, member);
        }
        return false;
    }

    @ExportMessage
    boolean hasMemberWriteSideEffects(String member, @Bind Node inliningTarget, @Cached.Shared(value="interop") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached InlinedIntValueProfile lengthProfile) {
        int length = lengthProfile.profile(inliningTarget, this.names.length);
        for (int i = this.scopeIndex; i < length; ++i) {
            Object scope = this.objects[i];
            if (!interop.isMemberWritable(scope, member)) continue;
            return interop.hasMemberWriteSideEffects(scope, member);
        }
        return false;
    }

    @ExportMessage
    void writeMember(String member, Object value, @Bind Node inliningTarget, @Cached.Shared(value="interop") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached InlinedIntValueProfile lengthProfile) throws UnknownIdentifierException, UnsupportedMessageException, UnsupportedTypeException {
        int length = lengthProfile.profile(inliningTarget, this.names.length);
        for (int i = this.scopeIndex; i < length; ++i) {
            Object scope = this.objects[i];
            if (interop.isMemberModifiable(scope, member) || interop.isMemberInsertable(scope, member)) {
                interop.writeMember(scope, member, value);
                return;
            }
            if (!interop.isMemberExisting(scope, member)) continue;
            throw UnsupportedMessageException.create();
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean isMemberRemovable(String member, @Bind Node inliningTarget, @Cached.Shared(value="interop") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached InlinedIntValueProfile lengthProfile) {
        int length = lengthProfile.profile(inliningTarget, this.names.length);
        for (int i = this.scopeIndex; i < length; ++i) {
            Object scope = this.objects[i];
            if (interop.isMemberRemovable(scope, member)) {
                return true;
            }
            if (!interop.isMemberExisting(scope, member)) continue;
            return false;
        }
        return false;
    }

    @ExportMessage
    void removeMember(String member, @Bind Node inliningTarget, @Cached.Shared(value="interop") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached InlinedIntValueProfile lengthProfile) throws UnsupportedMessageException, UnknownIdentifierException {
        int length = lengthProfile.profile(inliningTarget, this.names.length);
        for (int i = this.scopeIndex; i < length; ++i) {
            Object scope = this.objects[i];
            if (interop.isMemberRemovable(scope, member)) {
                interop.removeMember(scope, member);
                return;
            }
            if (interop.isMemberExisting(scope, member)) break;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return PythonLanguage.class;
    }

    @ExportMessage
    boolean isScope() {
        return true;
    }

    @ExportMessage
    Object toDisplayString(boolean allowSideEffects) {
        return this.names[this.scopeIndex];
    }
}

