/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.util;

import com.oracle.graal.python.runtime.exception.PythonThreadKillException;
import com.oracle.truffle.api.TruffleLogger;
import java.util.logging.Level;

public abstract class PythonSystemThreadTask
implements Runnable {
    private final String name;
    private final TruffleLogger logger;

    public PythonSystemThreadTask(String name, TruffleLogger logger) {
        this.name = name;
        this.logger = logger;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public final void run() {
        try {
            this.doRun();
            this.logger.fine(() -> String.format("'%s' finished", this.name));
        }
        catch (PythonThreadKillException ex) {
            this.logger.fine(() -> String.format("%s killed with exception '%s'", this.name, PythonThreadKillException.class.getSimpleName()));
        }
        catch (Throwable ex) {
            this.logger.log(Level.FINE, String.format("Unhandled exception %s in thread '%s'", ex.getClass().getSimpleName(), this.name), ex);
            throw ex;
        }
    }

    protected abstract void doRun();
}

