/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.logging.runtime;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import oracle.jdbc.logging.annotations.Blinder;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.runtime.Features;
import oracle.jdbc.logging.runtime.TraceController;

@DisableTrace
public class TraceControllerImpl
implements TraceController {
    private static final Features features;
    private RuntimeException reSuspended = new IllegalStateException("trace controller is currently suspended");
    public static long feature;
    private static long backup;
    private static int suspends;
    private static final ReentrantLock CLASS_LOCK;
    private static final Blinder<Object> bogusBlinder;
    private static final ConcurrentMap<Class<? extends Blinder<?>>, Blinder<?>> instantiatedBlindersMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trace(boolean enable, Feature ... features) {
        CLASS_LOCK.lock();
        try {
            if (0 != suspends) {
                throw this.reSuspended;
            }
            long fMask = 0L;
            for (Feature f2 : features) {
                fMask |= f2.bitVector();
            }
            feature = enable ? feature | fMask : feature & (fMask ^ 0xFFFFFFFFFFFFFFFFL);
        }
        finally {
            CLASS_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Feature[] getEnabledFeatures() {
        CLASS_LOCK.lock();
        try {
            if (0 != suspends) {
                Feature[] featureArray = new Feature[]{};
                return featureArray;
            }
            ArrayList<Feature> enabledFeatures = new ArrayList<Feature>();
            if (feature == Feature.ALL.bitVector()) {
                enabledFeatures.add(Feature.ALL);
            } else {
                for (Feature f2 : this.getSupportedFeatures()) {
                    if (Feature.ALL == f2 || 0L == (feature & f2.bitVector())) continue;
                    enabledFeatures.add(f2);
                }
            }
            Feature[] featureArray = enabledFeatures.toArray(new Feature[0]);
            return featureArray;
        }
        finally {
            CLASS_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Feature[] getSupportedFeatures() {
        CLASS_LOCK.lock();
        try {
            ArrayList<Feature> supportedFeatures = new ArrayList<Feature>();
            for (Feature feature : Feature.values()) {
                supportedFeatures.add(feature);
            }
            Feature[] featureArray = supportedFeatures.toArray(new Feature[0]);
            return featureArray;
        }
        finally {
            CLASS_LOCK.unlock();
        }
    }

    @Override
    public void suspend() {
        CLASS_LOCK.lock();
        try {
            if (0 == suspends++) {
                backup = feature;
                feature = 0L;
            }
        }
        finally {
            CLASS_LOCK.unlock();
        }
    }

    @Override
    public void resume() {
        CLASS_LOCK.lock();
        try {
            int s2 = --suspends;
            if (0 == s2) {
                feature = backup;
            } else if (s2 < 0) {
                suspends = 0;
            }
        }
        finally {
            CLASS_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTracing(Feature ... supportedFeatures) {
        CLASS_LOCK.lock();
        try {
            if (0 != suspends) {
                boolean bl = false;
                return bl;
            }
            boolean isTracing = true;
            for (Feature f2 : supportedFeatures) {
                if (0L != (feature & f2.bitVector())) continue;
                isTracing = false;
            }
            boolean bl = isTracing;
            return bl;
        }
        finally {
            CLASS_LOCK.unlock();
        }
    }

    private static <T> Blinder<T> getBlinder(Class<? extends Blinder<T>> blinderClass) {
        RuntimeException[] exception = new RuntimeException[]{null};
        Blinder blinder = instantiatedBlindersMap.computeIfAbsent(blinderClass, p2 -> {
            try {
                return (Blinder)p2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
                exception[0] = new RuntimeException(e2);
                return bogusBlinder;
            }
        });
        if (Objects.nonNull(exception[0])) {
            throw exception[0];
        }
        return blinder;
    }

    public static <T> String blind(Class<? extends Blinder<T>> blinderClass, T value) {
        return TraceControllerImpl.getBlinder(blinderClass).blind(value);
    }

    static {
        String trace;
        features = new Features("oracle.jdbc.logging.annotations.Supports");
        feature = Feature.ALL_UCP.bitVector();
        String prop = System.getProperty("oracle.jdbc.Trace");
        if (null != prop && ("true".equals(trace = prop.trim().toLowerCase()) || "on".equals(trace))) {
            feature |= Feature.ALL_JDBC.bitVector();
        }
        String PREFIX = "clio.feature";
        String configFile = System.getProperty("java.util.logging.config.file");
        if (null != configFile) {
            Properties props = new Properties();
            InputStream inputStream = TraceControllerImpl.class.getClassLoader().getResourceAsStream(configFile);
            if (null == inputStream) {
                try {
                    inputStream = new FileInputStream(configFile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (null != inputStream) {
                try {
                    props.load(inputStream);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            long selectedFeature = 0L;
            for (Feature f2 : Feature.values()) {
                String key = "clio.feature." + f2.toString().toLowerCase();
                String value = props.getProperty(key);
                if (null == value) continue;
                String v2 = value.toLowerCase().trim();
                if ("on".equals(v2) || "true".equals(v2)) {
                    selectedFeature |= f2.bitVector();
                    continue;
                }
                if (!"off".equals(v2) && !"false".equals(v2)) continue;
                selectedFeature &= f2.bitVector() ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if (0L != selectedFeature) {
                feature = selectedFeature;
            }
        }
        backup = 0L;
        suspends = 0;
        CLASS_LOCK = new ReentrantLock();
        bogusBlinder = p2 -> "*** error: bogus blinder invoked instead, an appropriate blinder was not properly instantiated ***";
        instantiatedBlindersMap = new ConcurrentHashMap();
    }
}

