/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core.sym;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import tools.jackson.core.sym.HashedMatcherBase;
import tools.jackson.core.sym.PropertyNameMatcher;
import tools.jackson.core.sym.SimpleNameMatcher;
import tools.jackson.core.util.Named;

public final class BinaryNameMatcher
extends HashedMatcherBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int MAX_ENTRIES = Short.MAX_VALUE;
    private static final int MAX_LENGTH_IN_QUADS = Short.MAX_VALUE;
    private int[] _hashArea;
    private int _hashSize;
    private int _secondaryStart;
    private int _tertiaryStart;
    private int _tertiaryShift;
    private int _count = 0;
    private int _spilloverEnd;
    private int _longNameOffset;
    private static final int MULT = 33;
    private static final int MULT2 = 65599;
    private static final int MULT3 = 31;

    private BinaryNameMatcher(SimpleNameMatcher matcher, String[] nameLookup, int hashSize) {
        super((HashedMatcherBase)matcher, nameLookup);
        this._hashSize = hashSize;
        this._hashArea = new int[hashSize << 3];
        this._secondaryStart = hashSize << 2;
        this._tertiaryStart = this._secondaryStart + (this._secondaryStart >> 1);
        this._tertiaryShift = BinaryNameMatcher._calcTertiaryShift(hashSize);
        this._spilloverEnd = this._hashArea.length - hashSize;
        this._longNameOffset = this._hashArea.length;
    }

    static int _calcTertiaryShift(int primarySlots) {
        int tertSlots = primarySlots >> 2;
        if (tertSlots < 64) {
            return 4;
        }
        if (tertSlots <= 256) {
            return 5;
        }
        if (tertSlots <= 1024) {
            return 6;
        }
        return 7;
    }

    public static BinaryNameMatcher constructFrom(List<Named> propertyNames, boolean alreadyInterned) {
        return BinaryNameMatcher.construct(BinaryNameMatcher.stringsFromNames(propertyNames, alreadyInterned));
    }

    public static BinaryNameMatcher construct(List<String> symbols) {
        return BinaryNameMatcher._construct(symbols, SimpleNameMatcher.construct(null, symbols));
    }

    public static BinaryNameMatcher constructCaseInsensitive(Locale locale, List<Named> propertyNames, boolean alreadyInterned) {
        List<String> names = PropertyNameMatcher.stringsFromNames(propertyNames, alreadyInterned);
        return BinaryNameMatcher._construct(names, SimpleNameMatcher.constructCaseInsensitive(locale, names));
    }

    private static BinaryNameMatcher _construct(List<String> symbols, SimpleNameMatcher base) {
        int sz = BinaryNameMatcher._findSize(symbols.size());
        String[] lookup = symbols.toArray(new String[0]);
        BinaryNameMatcher matcher = new BinaryNameMatcher(base, lookup, sz);
        for (String name : symbols) {
            matcher.addName(name);
        }
        return matcher;
    }

    public int addName(String name) {
        byte[] ch = name.getBytes(StandardCharsets.UTF_8);
        int len = ch.length;
        if (len <= 12) {
            if (len <= 4) {
                return this.addName(name, BinaryNameMatcher._decodeLast(ch, 0, len));
            }
            int q1 = BinaryNameMatcher._decodeFull(ch, 0);
            if (len <= 8) {
                return this.addName(name, q1, BinaryNameMatcher._decodeLast(ch, 4, len - 4));
            }
            return this.addName(name, q1, BinaryNameMatcher._decodeFull(ch, 4), BinaryNameMatcher._decodeLast(ch, 8, len - 8));
        }
        int[] quads = BinaryNameMatcher._quads(name);
        return this.addName(name, quads, quads.length);
    }

    private int addName(String name, int q1) {
        int index = this._count;
        int offset = this._findOffsetForAdd(this.calcHash(q1));
        this._hashArea[offset] = q1;
        this._hashArea[offset + 3] = this._lengthAndIndex(1);
        return index;
    }

    private int addName(String name, int q1, int q2) {
        int index = this._count;
        int offset = this._findOffsetForAdd(this.calcHash(q1, q2));
        this._hashArea[offset] = q1;
        this._hashArea[offset + 1] = q2;
        this._hashArea[offset + 3] = this._lengthAndIndex(2);
        return index;
    }

    private int addName(String name, int q1, int q2, int q3) {
        int index = this._count;
        int offset = this._findOffsetForAdd(this.calcHash(q1, q2, q3));
        this._hashArea[offset] = q1;
        this._hashArea[offset + 1] = q2;
        this._hashArea[offset + 2] = q3;
        this._hashArea[offset + 3] = this._lengthAndIndex(3);
        return index;
    }

    private int addName(String name, int[] q, int qlen) {
        int longStart;
        switch (qlen) {
            case 1: {
                return this.addName(name, q[0]);
            }
            case 2: {
                return this.addName(name, q[0], q[1]);
            }
            case 3: {
                return this.addName(name, q[0], q[1], q[2]);
            }
        }
        int index = this._count;
        int hash = this.calcHash(q, qlen);
        int offset = this._findOffsetForAdd(hash);
        this._hashArea[offset] = hash;
        this._hashArea[offset + 1] = longStart = this._appendLongName(q, qlen);
        this._hashArea[offset + 3] = this._lengthAndIndex(qlen);
        return index;
    }

    private int _findOffsetForAdd(int hash) {
        int[] hashArea = this._hashArea;
        int offset = this._calcOffset(hash);
        if (hashArea[offset + 3] == 0) {
            return offset;
        }
        int offset2 = this._secondaryStart + (offset >> 3 << 2);
        if (hashArea[offset2 + 3] == 0) {
            return offset2;
        }
        int bucketSize = 1 << this._tertiaryShift;
        int end = offset2 + bucketSize;
        for (offset2 = this._tertiaryStart + (offset >> this._tertiaryShift + 2 << this._tertiaryShift); offset2 < end; offset2 += 4) {
            if (hashArea[offset2 + 3] != 0) continue;
            return offset2;
        }
        offset = this._spilloverEnd;
        end = this._hashSize << 3;
        if (this._spilloverEnd >= end) {
            throw new IllegalStateException("Internal error: Overflow with " + this._count + " entries (hash size of " + this._hashSize + ")");
        }
        this._spilloverEnd += 4;
        return offset;
    }

    private int _appendLongName(int[] quads, int qlen) {
        int start = this._longNameOffset;
        if (start + qlen > this._hashArea.length) {
            int toAdd = start + qlen - this._hashArea.length;
            int minAdd = Math.min(4096, this._hashSize);
            int newSize = this._hashArea.length + Math.max(toAdd, minAdd);
            this._hashArea = Arrays.copyOf(this._hashArea, newSize);
        }
        System.arraycopy(quads, 0, this._hashArea, start, qlen);
        this._longNameOffset += qlen;
        return start;
    }

    public int size() {
        return this._count;
    }

    public int bucketCount() {
        return this._hashSize;
    }

    public int primaryQuadCount() {
        int count = 0;
        int end = this._secondaryStart;
        for (int offset = 3; offset < end; offset += 4) {
            if (this._hashArea[offset] == 0) continue;
            ++count;
        }
        return count;
    }

    public int secondaryQuadCount() {
        int count = 0;
        int end = this._tertiaryStart;
        for (int offset = this._secondaryStart + 3; offset < end; offset += 4) {
            if (this._hashArea[offset] == 0) continue;
            ++count;
        }
        return count;
    }

    public int tertiaryQuadCount() {
        int offset;
        int count = 0;
        int end = offset + this._hashSize;
        for (offset = this._tertiaryStart + 3; offset < end; offset += 4) {
            if (this._hashArea[offset] == 0) continue;
            ++count;
        }
        return count;
    }

    public int spilloverQuadCount() {
        return this._spilloverEnd - this._spilloverStart() >> 2;
    }

    public int totalCount() {
        int count = 0;
        int end = this._hashSize << 3;
        for (int offset = 3; offset < end; offset += 4) {
            if (this._hashArea[offset] == 0) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int matchByQuad(int q1) {
        int offset2;
        int[] hashArea = this._hashArea;
        int offset = this._calcOffset(this.calcHash(q1));
        int lenAndIndex = hashArea[offset + 3];
        if ((lenAndIndex & 0xFFFF) == 1) {
            if (hashArea[offset] == q1) {
                return lenAndIndex >> 16;
            }
        } else if (lenAndIndex == 0) {
            return -1;
        }
        if (((lenAndIndex = hashArea[(offset2 = this._secondaryStart + (offset >> 3 << 2)) + 3]) & 0xFFFF) == 1) {
            if (hashArea[offset2] == q1) {
                return lenAndIndex >> 16;
            }
        } else if (lenAndIndex == 0) {
            return -1;
        }
        return this._findTertiary(offset, q1);
    }

    @Override
    public int matchByQuad(int q1, int q2) {
        int offset2;
        int lenAndIndex2;
        int[] hashArea = this._hashArea;
        int offset = this._calcOffset(this.calcHash(q1, q2));
        int lenAndIndex = hashArea[offset + 3];
        if ((lenAndIndex & 0xFFFF) == 2) {
            if (q1 == hashArea[offset] && q2 == hashArea[offset + 1]) {
                return lenAndIndex >> 16;
            }
        } else if (lenAndIndex == 0) {
            return -1;
        }
        if (((lenAndIndex2 = hashArea[(offset2 = this._secondaryStart + (offset >> 3 << 2)) + 3]) & 0xFFFF) == 2) {
            if (q1 == hashArea[offset2] && q2 == hashArea[offset2 + 1]) {
                return lenAndIndex2 >> 16;
            }
        } else if (lenAndIndex2 == 0) {
            return -1;
        }
        return this._findTertiary(offset, q1, q2);
    }

    @Override
    public int matchByQuad(int q1, int q2, int q3) {
        int offset2;
        int lenAndIndex2;
        int[] hashArea = this._hashArea;
        int offset = this._calcOffset(this.calcHash(q1, q2, q3));
        int lenAndIndex = hashArea[offset + 3];
        if ((lenAndIndex & 0xFFFF) == 3) {
            if (q1 == hashArea[offset] && hashArea[offset + 1] == q2 && hashArea[offset + 2] == q3) {
                return lenAndIndex >> 16;
            }
        } else if (lenAndIndex == 0) {
            return -1;
        }
        if (((lenAndIndex2 = hashArea[(offset2 = this._secondaryStart + (offset >> 3 << 2)) + 3]) & 0xFFFF) == 3) {
            if (q1 == hashArea[offset2] && hashArea[offset2 + 1] == q2 && hashArea[offset2 + 2] == q3) {
                return lenAndIndex2 >> 16;
            }
        } else if (lenAndIndex2 == 0) {
            return -1;
        }
        return this._findTertiary(offset, q1, q2, q3);
    }

    @Override
    public int matchByQuad(int[] q, int qlen) {
        if (qlen < 4) {
            switch (qlen) {
                case 3: {
                    return this.matchByQuad(q[0], q[1], q[2]);
                }
                case 2: {
                    return this.matchByQuad(q[0], q[1]);
                }
                case 1: {
                    return this.matchByQuad(q[0]);
                }
            }
            return -1;
        }
        int hash = this.calcHash(q, qlen);
        int offset = this._calcOffset(hash);
        int[] hashArea = this._hashArea;
        int lenAndIndex = hashArea[offset + 3];
        if (hash == hashArea[offset] && (lenAndIndex & 0xFFFF) == qlen && this._verifyLongName(q, qlen, hashArea[offset + 1])) {
            return lenAndIndex >> 16;
        }
        if (lenAndIndex == 0) {
            return -1;
        }
        int offset2 = this._secondaryStart + (offset >> 3 << 2);
        int lenAndIndex2 = hashArea[offset2 + 3];
        if (hash == hashArea[offset2] && (lenAndIndex2 & 0xFFFF) == qlen && this._verifyLongName(q, qlen, hashArea[offset2 + 1])) {
            return lenAndIndex2 >> 16;
        }
        return this._findTertiary(offset, hash, q, qlen);
    }

    private final int _calcOffset(int hash) {
        int ix = hash & this._hashSize - 1;
        return ix << 2;
    }

    private int _findTertiary(int origOffset, int q1) {
        int offset;
        int[] hashArea = this._hashArea;
        int bucketSize = 1 << this._tertiaryShift;
        int end = offset + bucketSize;
        for (offset = this._tertiaryStart + (origOffset >> this._tertiaryShift + 2 << this._tertiaryShift); offset < end; offset += 4) {
            int lenAndIndex = hashArea[offset + 3];
            if (q1 == hashArea[offset] && 1 == (lenAndIndex & 0xFFFF)) {
                return lenAndIndex >> 16;
            }
            if (lenAndIndex != 0) continue;
            return -1;
        }
        for (offset = this._spilloverStart(); offset < this._spilloverEnd; offset += 4) {
            int lenAndIndex;
            if (q1 != hashArea[offset] || 1 != ((lenAndIndex = hashArea[offset + 3]) & 0xFFFF)) continue;
            return lenAndIndex >> 16;
        }
        return -1;
    }

    private int _findTertiary(int origOffset, int q1, int q2) {
        int offset;
        int[] hashArea = this._hashArea;
        int bucketSize = 1 << this._tertiaryShift;
        int end = offset + bucketSize;
        for (offset = this._tertiaryStart + (origOffset >> this._tertiaryShift + 2 << this._tertiaryShift); offset < end; offset += 4) {
            int lenAndIndex = hashArea[offset + 3];
            if (q1 == hashArea[offset] && q2 == hashArea[offset + 1] && 2 == (lenAndIndex & 0xFFFF)) {
                return lenAndIndex >> 16;
            }
            if (lenAndIndex != 0) continue;
            return -1;
        }
        for (offset = this._spilloverStart(); offset < this._spilloverEnd; offset += 4) {
            int lenAndIndex;
            if (q1 != hashArea[offset] || q2 != hashArea[offset + 1] || 2 != ((lenAndIndex = hashArea[offset + 3]) & 0xFFFF)) continue;
            return lenAndIndex >> 16;
        }
        return -1;
    }

    private int _findTertiary(int origOffset, int q1, int q2, int q3) {
        int offset;
        int[] hashArea = this._hashArea;
        int bucketSize = 1 << this._tertiaryShift;
        int end = offset + bucketSize;
        for (offset = this._tertiaryStart + (origOffset >> this._tertiaryShift + 2 << this._tertiaryShift); offset < end; offset += 4) {
            int lenAndIndex = hashArea[offset + 3];
            if (q1 == hashArea[offset] && q2 == hashArea[offset + 1] && q3 == hashArea[offset + 2] && 3 == (lenAndIndex & 0xFFFF)) {
                return lenAndIndex >> 16;
            }
            if (lenAndIndex != 0) continue;
            return -1;
        }
        for (offset = this._spilloverStart(); offset < this._spilloverEnd; offset += 4) {
            int lenAndIndex;
            if (q1 != hashArea[offset] || q2 != hashArea[offset + 1] || q3 != hashArea[offset + 2] || 3 != ((lenAndIndex = hashArea[offset + 3]) & 0xFFFF)) continue;
            return lenAndIndex >> 16;
        }
        return -1;
    }

    private int _findTertiary(int origOffset, int hash, int[] q, int qlen) {
        int offset;
        int[] hashArea = this._hashArea;
        int bucketSize = 1 << this._tertiaryShift;
        int end = offset + bucketSize;
        for (offset = this._tertiaryStart + (origOffset >> this._tertiaryShift + 2 << this._tertiaryShift); offset < end; offset += 4) {
            int lenAndIndex = hashArea[offset + 3];
            if (hash == hashArea[offset] && qlen == (lenAndIndex & 0xFFFF) && this._verifyLongName(q, qlen, hashArea[offset + 1])) {
                return lenAndIndex >> 16;
            }
            if (lenAndIndex != 0) continue;
            return -1;
        }
        for (offset = this._spilloverStart(); offset < this._spilloverEnd; offset += 4) {
            int lenAndIndex;
            if (hash != hashArea[offset] || qlen != ((lenAndIndex = hashArea[offset + 3]) & 0xFFFF) || !this._verifyLongName(q, qlen, hashArea[offset + 1])) continue;
            return lenAndIndex >> 16;
        }
        return -1;
    }

    private boolean _verifyLongName(int[] q, int qlen, int spillOffset) {
        int[] hashArea = this._hashArea;
        int ix = 0;
        switch (qlen) {
            default: {
                return this._verifyLongName2(q, qlen, spillOffset);
            }
            case 8: {
                if (q[ix++] != hashArea[spillOffset++]) {
                    return false;
                }
            }
            case 7: {
                if (q[ix++] != hashArea[spillOffset++]) {
                    return false;
                }
            }
            case 6: {
                if (q[ix++] != hashArea[spillOffset++]) {
                    return false;
                }
            }
            case 5: {
                if (q[ix++] == hashArea[spillOffset++]) break;
                return false;
            }
            case 4: 
        }
        if (q[ix++] != hashArea[spillOffset++]) {
            return false;
        }
        if (q[ix++] != hashArea[spillOffset++]) {
            return false;
        }
        if (q[ix++] != hashArea[spillOffset++]) {
            return false;
        }
        return q[ix++] == hashArea[spillOffset++];
    }

    private boolean _verifyLongName2(int[] q, int qlen, int spillOffset) {
        int ix = 0;
        do {
            if (q[ix++] == this._hashArea[spillOffset++]) continue;
            return false;
        } while (ix < qlen);
        return true;
    }

    public int calcHash(int q1) {
        int hash = q1 + (q1 >>> 16) ^ q1 << 3;
        return hash + (hash >>> 11);
    }

    public int calcHash(int q1, int q2) {
        int hash = q1 + (q1 >>> 15) ^ q1 >>> 9;
        hash += q2 * 33 ^ q2 >>> 15;
        hash += (hash >>> 7) + (hash >>> 3);
        return hash;
    }

    public int calcHash(int q1, int q2, int q3) {
        int hash = q1 + (q1 >>> 15) ^ q1 >>> 9;
        hash = hash * 33 + q2 ^ (q2 >>> 15) + (q2 >> 7);
        hash = hash * 31 + q3 ^ (q3 >>> 13) + (q3 >> 9);
        hash += hash >>> 4;
        return hash;
    }

    public int calcHash(int[] q, int qlen) {
        if (qlen < 4) {
            throw new IllegalArgumentException();
        }
        int hash = q[0];
        hash += hash >>> 9;
        hash += q[1];
        hash += hash >>> 15;
        hash *= 33;
        hash ^= q[2];
        hash += hash >>> 4;
        for (int i = 3; i < qlen; ++i) {
            int next = q[i];
            next ^= next >> 21;
            hash += next;
        }
        hash *= 65599;
        hash += hash >>> 19;
        hash ^= hash << 5;
        return hash;
    }

    public String toString() {
        int pri = this.primaryQuadCount();
        int sec = this.secondaryQuadCount();
        int tert = this.tertiaryQuadCount();
        int spill = this.spilloverQuadCount();
        int total = this.totalCount();
        return String.format("[%s: size=%d, hashSize=%d, %d/%d/%d/%d pri/sec/ter/spill (=%s), total:%d]", this.getClass().getName(), this._count, this._hashSize, pri, sec, tert, spill, pri + sec + tert + spill, total);
    }

    public static int[] _quads(String name) {
        int left;
        byte[] b = name.getBytes(StandardCharsets.UTF_8);
        int len = b.length;
        int[] buf = new int[len + 3 >> 2];
        int in = 0;
        int out = 0;
        for (left = len; left > 4; left -= 4) {
            buf[out++] = BinaryNameMatcher._decodeFull(b, in);
            in += 4;
        }
        buf[out++] = BinaryNameMatcher._decodeLast(b, in, left);
        return buf;
    }

    private static int _decodeFull(byte[] b, int offset) {
        return (b[offset] << 24) + ((b[offset + 1] & 0xFF) << 16) + ((b[offset + 2] & 0xFF) << 8) + (b[offset + 3] & 0xFF);
    }

    private static int _decodeLast(byte[] b, int offset, int bytes) {
        int value = b[offset++] & 0xFF;
        switch (bytes) {
            case 4: {
                value = value << 8 | b[offset++] & 0xFF;
            }
            case 3: {
                value = value << 8 | b[offset++] & 0xFF;
            }
            case 2: {
                value = value << 8 | b[offset++] & 0xFF;
            }
        }
        return value;
    }

    private int _lengthAndIndex(int qlen) {
        if (qlen > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Maximum name length in quads (32767) exceeded: " + qlen);
        }
        if (this._count == Short.MAX_VALUE) {
            throw new IllegalArgumentException("Maximum entry count (32767) reached, cannot add more entries");
        }
        int enc = this._count << 16 | qlen;
        ++this._count;
        return enc;
    }

    private int _spilloverStart() {
        int offset = this._hashSize;
        return (offset << 3) - offset;
    }
}

