/*
 * Decompiled with CFR 0.152.
 */
package mso.generator.utils;

import java.util.ArrayList;
import java.util.List;
import mso.generator.utils.Lim;
import mso.generator.utils.Limitation;
import mso.generator.utils.Member;
import mso.generator.utils.Option;
import mso.generator.utils.Struct;
import mso.generator.utils.Type;
import mso.generator.utils.TypeRegistry;
import org.eclipse.jdt.annotation.Nullable;

public class Choice
extends Type {
    public final @Nullable Type commonType;
    public final List<Option> options = new ArrayList<Option>();

    public String[] getChoiceNames() {
        String[] stringArray = new String[this.options.size()];
        for (int i = 0; i < this.options.size(); ++i) {
            stringArray[i] = this.options.get((int)i).type.name;
        }
        return stringArray;
    }

    Choice(TypeRegistry typeRegistry, String string, List<Struct> list, boolean bl) {
        super(typeRegistry, string, Choice.getSize(list));
        Object object;
        Type type = null;
        for (Struct object2 : list) {
            object = Option.parseOption(object2, type);
            if (type != null && ((Option)object).limitsType != type && !Choice.compareTypes(type, ((Option)object).limitsType)) {
                throw new Error("Conflicting common type: " + type.name + " vs " + ((Option)object).limitsType.name);
            }
            type = ((Option)object).limitsType;
            this.options.add((Option)object);
        }
        for (Option option : this.options) {
            if (Choice.compareTypes(type, option.limitsType)) continue;
            object = "";
            for (Option option2 : this.options) {
                object = (String)object + " " + option2.type.name;
            }
            System.err.println("The choice " + string + " has no common options for types" + (String)object);
            type = null;
            break;
        }
        if (type == null) {
            this.commonType = null;
            return;
        }
        for (int i = 0; i < this.options.size(); ++i) {
            int n = bl ? this.options.size() : this.options.size() - 1;
            for (int j = i + 1; j < n; ++j) {
                Option option2;
                Option option = this.options.get(i);
                option2 = this.options.get(j);
                if (Choice.noOverlap(option.lim, option2.lim)) continue;
                System.err.println("Options " + option.type.name + " and " + option2.type.name + " have overlap.");
                type = null;
            }
        }
        this.commonType = type;
        if (!bl && type != null) {
            Choice.removeNonDistinctiveLimitations(this.options);
        }
    }

    private static int getSize(List<Struct> list) {
        int n = -1;
        for (Struct struct : list) {
            if (n == -1) {
                n = struct.size;
            }
            if (struct.size == n) continue;
            return -1;
        }
        return n;
    }

    private static boolean noOverlap(Lim lim, Lim lim2) {
        if (lim.limitations == null && lim.lims == null) {
            return false;
        }
        if (lim.limitations != null && !Choice.noOverlap(lim.limitations, lim2)) {
            return false;
        }
        if (lim.lims != null) {
            for (Lim lim3 : lim.lims) {
                if (Choice.noOverlap(lim3, lim2)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean noOverlap(Limitation[] limitationArray, Lim lim) {
        if (lim.limitations == null && lim.lims == null) {
            return false;
        }
        if (lim.limitations != null && !Choice.noOverlap(limitationArray, lim.limitations)) {
            return false;
        }
        if (lim.lims != null) {
            for (Lim lim2 : lim.lims) {
                if (Choice.noOverlap(limitationArray, lim2)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean noOverlap(Limitation[] limitationArray, Limitation[] limitationArray2) {
        for (int i = 0; i < limitationArray.length; ++i) {
            for (int j = 0; j < limitationArray2.length; ++j) {
                if (!limitationArray[i].name.equals(limitationArray2[j].name) || !Choice.noOverlap(limitationArray[i].value, limitationArray2[j].value)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean noOverlap(@Nullable String string, @Nullable String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        String[] stringArray = string.split("\\|");
        String[] stringArray2 = string2.split("\\|");
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray2.length; ++j) {
                if (!stringArray[i].equals(stringArray2[j])) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean compareMembers(Member member, Member member2) {
        if (member.isArray != member2.isArray) {
            return false;
        }
        if (member.type() != member2.type()) {
            return false;
        }
        return member.isOptional == member2.isOptional;
    }

    private static boolean structsWithSameMembers(@Nullable Type type, Type type2) {
        if (type instanceof Struct && type2 instanceof Struct) {
            Struct struct = (Struct)type;
            Struct struct2 = (Struct)type2;
            if (struct.members.size() != struct2.members.size()) {
                return false;
            }
            for (int i = 0; i < struct.members.size(); ++i) {
                if (Choice.compareMembers(struct.members.get(i), struct2.members.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean compareTypes(@Nullable Type type, Type type2) {
        return type == type2 || Choice.structsWithSameMembers(type, type2);
    }

    private static void removeNonDistinctiveLimitations(List<Option> list) {
        Lim lim = list.get((int)0).lim;
        Limitation[] limitationArray = lim.limitations;
        if (limitationArray != null) {
            for (int i = 0; i < limitationArray.length; ++i) {
                int n;
                Limitation limitation = limitationArray[i];
                boolean bl = true;
                for (n = 1; n < list.size(); ++n) {
                    bl = bl && list.get((int)n).lim.containsCommonLimitation(limitation);
                }
                if (!bl) continue;
                for (n = 0; n < list.size(); ++n) {
                    list.get((int)n).lim.removeLimitation(limitation);
                }
                i = 0;
            }
        }
    }
}

