/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.notification.ris;

import com.sourceforge.knecs.dsm.resourceobject.DataRequest;
import com.sourceforge.knecs.dsm.resourceobject.ExpertiseProfile;
import com.sourceforge.knecs.dsm.resourceobject.ISubscriptionService;
import com.sourceforge.knecs.dsm.resourceobject.Interest;
import com.sourceforge.knecs.dsm.resourceobject.RISException;
import com.sourceforge.knecs.notification.ris.JMSRISService;
import com.sourceforge.knecs.util.CMCSProperties;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class JMSRISSubscriptionService
extends JMSRISService
implements ISubscriptionService {
    public static final String INTEREST_CN = "com.sourceforge.knecs.dsm.resourceobject.Interest";
    public static final String DATAREQUEST_CN = "com.sourceforge.knecs.dsm.resourceobject.DataRequest";
    public static final String PROFILE_CN = "com.sourceforge.knecs.dsm.resourceobject.ExpertiseProfile";
    private static Vector mClassNames = new Vector();

    public JMSRISSubscriptionService(String serviceURL) {
        super(serviceURL, mClassNames);
        System.out.println("In JMSRISSubsriptionService" + serviceURL);
    }

    public synchronized Vector getURLFilters() {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        String svr = props.getProperty("samserver");
        String path = props.getProperty("portalobjects");
        String interests = props.getProperty("interest");
        String requests = props.getProperty("datarequest");
        String profiles = props.getProperty("expertiseprofile");
        Vector<String> ret = new Vector<String>();
        ret.add("%" + path + "/" + interests + "%");
        ret.add("%" + path + "/" + requests + "%");
        ret.add("%" + path + "/" + profiles + "%");
        return ret;
    }

    public Interest[] getInterests() throws IOException {
        Collection objects = this.getAllResourceObjects(INTEREST_CN);
        Iterator it = objects.iterator();
        Interest[] ret = new Interest[objects.size()];
        int idx = 0;
        while (it.hasNext()) {
            ret[idx++] = (Interest)it.next();
        }
        return ret;
    }

    public int removeInterests(String owner) throws IOException {
        return this.removeResourceObjectsByOwner(owner, INTEREST_CN);
    }

    public Interest[] getInterests(String owner) throws IOException {
        Collection objects = this.getResourceObjectsByOwner(owner, INTEREST_CN);
        Iterator it = objects.iterator();
        Interest[] ret = new Interest[objects.size()];
        int idx = 0;
        while (it.hasNext()) {
            ret[idx++] = (Interest)it.next();
        }
        return ret;
    }

    public void addInterest(Interest data) throws IOException {
        try {
            this.save(data);
        }
        catch (RISException risex) {
            this.mLogger.severe("Unable to save Interest " + risex.getMessage());
            throw new IOException(risex.getMessage());
        }
    }

    public boolean deleteInterest(Interest data) throws IOException {
        try {
            this.remove(data);
        }
        catch (RISException risex) {
            this.mLogger.severe("Unable to remove Interest " + risex.getMessage());
            throw new IOException(risex.getMessage());
        }
        return true;
    }

    public DataRequest[] getDataRequest() throws IOException {
        Collection objects = this.getAllResourceObjects(DATAREQUEST_CN);
        Iterator it = objects.iterator();
        DataRequest[] ret = new DataRequest[objects.size()];
        int idx = 0;
        while (it.hasNext()) {
            ret[idx++] = (DataRequest)it.next();
        }
        return ret;
    }

    public DataRequest[] getDataRequest(String owner) throws IOException {
        Collection objects = this.getResourceObjectsByOwner(owner, DATAREQUEST_CN);
        Iterator it = objects.iterator();
        DataRequest[] ret = new DataRequest[objects.size()];
        int idx = 0;
        while (it.hasNext()) {
            ret[idx++] = (DataRequest)it.next();
        }
        return ret;
    }

    public int removeDataRequests(String owner) throws IOException {
        return this.removeResourceObjectsByOwner(owner, DATAREQUEST_CN);
    }

    public void addDataRequest(DataRequest data) throws IOException {
        try {
            this.save(data);
        }
        catch (RISException risex) {
            this.mLogger.severe("Unable to save DataRequest " + risex.getMessage());
            throw new IOException(risex.getMessage());
        }
    }

    public boolean deleteDataRequest(DataRequest data) throws IOException {
        try {
            this.remove(data);
        }
        catch (RISException risex) {
            this.mLogger.severe("Unable to remove DataRequest " + risex.getMessage());
            throw new IOException(risex.getMessage());
        }
        return true;
    }

    public ExpertiseProfile[] getProfiles() throws IOException {
        Collection objects = this.getAllResourceObjects(PROFILE_CN);
        Iterator it = objects.iterator();
        ExpertiseProfile[] ret = new ExpertiseProfile[objects.size()];
        int idx = 0;
        while (it.hasNext()) {
            ret[idx++] = (ExpertiseProfile)it.next();
        }
        return ret;
    }

    public ExpertiseProfile[] getProfile(String owner) throws IOException {
        Collection objects = this.getResourceObjectsByOwner(owner, PROFILE_CN);
        Iterator it = objects.iterator();
        ExpertiseProfile[] ret = new ExpertiseProfile[objects.size()];
        int idx = 0;
        while (it.hasNext()) {
            ret[idx++] = (ExpertiseProfile)it.next();
        }
        return ret;
    }

    public int removeProfiles(String owner) throws IOException {
        return this.removeResourceObjectsByOwner(owner, PROFILE_CN);
    }

    public void updateProfile(ExpertiseProfile data) throws IOException {
        try {
            this.save(data);
        }
        catch (RISException risex) {
            this.mLogger.severe("Unable to save Profile " + risex.getMessage());
            throw new IOException(risex.getMessage());
        }
    }

    public boolean deleteProfile(ExpertiseProfile data) throws IOException {
        try {
            this.remove(data);
        }
        catch (RISException risex) {
            this.mLogger.severe("Unable to remote Profile " + risex.getMessage());
            throw new IOException(risex.getMessage());
        }
        return true;
    }

    static {
        mClassNames.add(INTEREST_CN);
        mClassNames.add(DATAREQUEST_CN);
        mClassNames.add(PROFILE_CN);
    }
}

