/*
 * Sentinella
 * http://sentinella.sourceforge.net/
 * Copyright (c) 2009-2011 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "Network.h"

Network::Network(NetworkInterface* networkInterfaceAPI, const qint64 msecsLimit,
		const qint64 interval, const QString& interfaceName, const uint32_t speedLimit,
		const bool bigger, const TrafficDirection direction) :
	AbstractLoopCondition(msecsLimit, interval), networkInterfaceAPI(networkInterfaceAPI),
			speedLimit(speedLimit), bigger(bigger), direction(direction), interfaceName(
					interfaceName) {
	memset(&old_interface_data, 0, sizeof old_interface_data);
	evaluate();
}

bool Network::evaluate() {
	struct sa_net_interface new_interface_data;
	networkInterfaceAPI->getNetworkInterface(interfaceName, &new_interface_data);
	if ((error = networkInterfaceAPI->error) != 0)
		return 0;

	uint64_t speed;
	if (direction == DOWNLOAD)
		speed = new_interface_data.received_bytes - old_interface_data.received_bytes;
	else
		speed = new_interface_data.sent_bytes - old_interface_data.sent_bytes;
	speed = speed / (interval / 1000);

	old_interface_data = new_interface_data;
	return bigger ? speed > speedLimit : speed < speedLimit;
}
